/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.agl.sppt;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.akehurst.language.api.sppt.SPPTBranch;
import net.akehurst.language.api.sppt.SPPTLeaf;
import net.akehurst.language.api.sppt.SPPTNode;
import net.akehurst.language.api.sppt.SharedPackedParseTree;
import net.akehurst.language.api.sppt.SharedPackedParseTreeVisitor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J:\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\f\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J2\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\f\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u001e"}, d2={"Lnet/akehurst/language/agl/sppt/ToStringVisitor;", "Lnet/akehurst/language/api/sppt/SharedPackedParseTreeVisitor;", "", "", "Lnet/akehurst/language/agl/sppt/ToStringVisitor$Indent;", "lineSeparator", "indentIncrement", "(Ljava/lang/String;Ljava/lang/String;)V", "getIndentIncrement", "()Ljava/lang/String;", "getLineSeparator", "visitBranch", "target", "Lnet/akehurst/language/api/sppt/SPPTBranch;", "arg", "visitChild", "", "currentSet", "children", "", "Lnet/akehurst/language/api/sppt/SPPTNode;", "index", "", "indent", "visitLeaf", "Lnet/akehurst/language/api/sppt/SPPTLeaf;", "visitOnlyChild", "visitTree", "Lnet/akehurst/language/api/sppt/SharedPackedParseTree;", "Indent", "agl-processor"})
public final class ToStringVisitor
implements SharedPackedParseTreeVisitor<Set<? extends String>, Indent> {
    @NotNull
    private final String lineSeparator;
    @NotNull
    private final String indentIncrement;

    public ToStringVisitor(@NotNull String lineSeparator, @NotNull String indentIncrement) {
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        Intrinsics.checkNotNullParameter((Object)indentIncrement, (String)"indentIncrement");
        this.lineSeparator = lineSeparator;
        this.indentIncrement = indentIncrement;
    }

    @NotNull
    public final String getLineSeparator() {
        return this.lineSeparator;
    }

    @NotNull
    public final String getIndentIncrement() {
        return this.indentIncrement;
    }

    @Override
    @NotNull
    public Set<String> visitTree(@NotNull SharedPackedParseTree target, @NotNull Indent arg) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return (Set)this.visitNode(target.getRoot(), (Object)arg);
    }

    @Override
    @NotNull
    public Set<String> visitLeaf(@NotNull SPPTLeaf target, @NotNull Indent arg) {
        String string;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        if (target.isEmptyLeaf()) {
            string = String.valueOf(target.getName());
        } else if (target.isLiteral()) {
            string = '\'' + StringsKt.replace$default((String)target.getMatchedText(), (String)"\n", (String)"\u23ce", (boolean)false, (int)4, null) + '\'';
        } else if (target.isPattern()) {
            string = target.getName() + " : '" + StringsKt.replace$default((String)target.getMatchedText(), (String)"\n", (String)"\u23ce", (boolean)false, (int)4, null) + '\'';
        } else {
            throw new RuntimeException("should not happen");
        }
        String t = string;
        String s = Intrinsics.stringPlus((String)(arg.getOnlyChild() ? " " : arg.getText()), (Object)t);
        return SetsKt.setOf((Object)s);
    }

    @Override
    @NotNull
    public Set<String> visitBranch(@NotNull SPPTBranch target, @NotNull Indent arg) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        HashSet<String> r = new HashSet<String>();
        for (List<SPPTNode> children : target.getChildrenAlternatives()) {
            Iterator<String> iterator;
            Set<String> currentSet;
            String s = arg.getOnlyChild() ? " " : arg.getText();
            s = Intrinsics.stringPlus((String)s, (Object)target.getName());
            if (target.getOption() != 0) {
                s = s + '|' + target.getOption();
            }
            s = Intrinsics.stringPlus((String)s, (Object)(target.getChildrenAlternatives().size() > 1 ? "*" : ""));
            s = Intrinsics.stringPlus((String)s, (Object)" {");
            if (children.isEmpty()) {
                s = Intrinsics.stringPlus((String)s, (Object)"}");
                r.add(s);
                continue;
            }
            if (children.size() == 1) {
                boolean bl = false;
                currentSet = new LinkedHashSet();
                currentSet.add(s);
                currentSet = this.visitOnlyChild(currentSet, children, arg);
                iterator = currentSet.iterator();
                while (iterator.hasNext()) {
                    String sc;
                    String sc1 = sc = iterator.next();
                    sc1 = Intrinsics.stringPlus((String)sc1, (Object)"}");
                    r.add(sc1);
                }
                continue;
            }
            s = Intrinsics.stringPlus((String)s, (Object)this.lineSeparator);
            currentSet = new HashSet();
            currentSet.add(s);
            int n = 0;
            int sc = children.size();
            if (n < sc) {
                do {
                    int i = n++;
                    currentSet = this.visitChild(currentSet, children, i, arg);
                } while (n < sc);
            }
            iterator = currentSet.iterator();
            while (iterator.hasNext()) {
                String sc1 = sc = iterator.next();
                sc1 = Intrinsics.stringPlus((String)sc1, (Object)arg.getText());
                sc1 = Intrinsics.stringPlus((String)sc1, (Object)"}");
                r.add(sc1);
            }
        }
        return r;
    }

    private final Set<String> visitOnlyChild(Set<String> currentSet, List<? extends SPPTNode> children, Indent indent) {
        HashSet<String> r = new HashSet<String>();
        Set ssc = (Set)this.visitNode(children.get(0), (Object)indent.next(this.indentIncrement, true));
        for (String current : currentSet) {
            for (String sc : ssc) {
                StringBuilder b = new StringBuilder(current);
                b.append(sc);
                b.append(" ");
                r.add(b.toString());
            }
        }
        return r;
    }

    private final Set<String> visitChild(Set<String> currentSet, List<? extends SPPTNode> children, int index, Indent indent) {
        HashSet<String> r = new HashSet<String>();
        Set ssc = (Set)this.visitNode(children.get(index), (Object)indent.next(this.indentIncrement, false));
        for (String current : currentSet) {
            for (String sc : ssc) {
                StringBuilder b = new StringBuilder(current);
                b.append(sc);
                b.append(this.lineSeparator);
                r.add(b.toString());
            }
        }
        return r;
    }

    @Override
    @NotNull
    public Set<String> visitNode(@NotNull SPPTNode target, @NotNull Indent arg) {
        return SharedPackedParseTreeVisitor.DefaultImpls.visitNode(this, target, arg);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lnet/akehurst/language/agl/sppt/ToStringVisitor$Indent;", "", "text", "", "onlyChild", "", "(Ljava/lang/String;Z)V", "getOnlyChild", "()Z", "getText", "()Ljava/lang/String;", "next", "increment", "agl-processor"})
    public static final class Indent {
        @NotNull
        private final String text;
        private final boolean onlyChild;

        public Indent(@NotNull String text, boolean onlyChild) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = text;
            this.onlyChild = onlyChild;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final boolean getOnlyChild() {
            return this.onlyChild;
        }

        @NotNull
        public final Indent next(@NotNull String increment, boolean onlyChild) {
            Intrinsics.checkNotNullParameter((Object)increment, (String)"increment");
            return new Indent(Intrinsics.stringPlus((String)this.text, (Object)increment), onlyChild);
        }
    }
}

