/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.agl.analyser;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.akehurst.language.api.analyser.GrammarLoader;
import net.akehurst.language.api.analyser.SyntaxAnalyser;
import net.akehurst.language.api.analyser.SyntaxAnalyserException;
import net.akehurst.language.api.sppt.SPPTBranch;
import net.akehurst.language.api.sppt.SPPTLeaf;
import net.akehurst.language.api.sppt.SPPTNode;
import net.akehurst.language.api.sppt.SharedPackedParseTree;
import net.akehurst.language.api.sppt.SharedPackedParseTreeVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J@\u0010\u000e\u001a,\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u0002H\u000f0\bj\b\u0012\u0004\u0012\u0002H\u000f`\u000b\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002JH\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u000720\u0010\u0013\u001a,\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u0002H\u000f0\bj\b\u0012\u0004\u0012\u0002H\u000f`\u000bH\u0004J%\u0010\u0014\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0004\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0018\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0004\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001c2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016R@\u0010\u0005\u001a4\u0012\u0004\u0012\u00020\u0007\u0012*\u0012(\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0002\b\u00030\bj\u0006\u0012\u0002\b\u0003`\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnet/akehurst/language/agl/analyser/SyntaxAnalyserAbstract;", "Lnet/akehurst/language/api/analyser/SyntaxAnalyser;", "Lnet/akehurst/language/api/sppt/SharedPackedParseTreeVisitor;", "", "()V", "branchHandlers", "", "", "Lkotlin/Function3;", "Lnet/akehurst/language/api/sppt/SPPTBranch;", "", "Lnet/akehurst/language/agl/analyser/BranchHandler;", "grammarLoader", "Lnet/akehurst/language/api/analyser/GrammarLoader;", "findBranchHandler", "T", "branchName", "register", "", "handler", "transform", "branch", "arg", "(Lnet/akehurst/language/api/sppt/SPPTBranch;Ljava/lang/Object;)Ljava/lang/Object;", "transformOpt", "visit", "target", "Lnet/akehurst/language/api/sppt/SPPTLeaf;", "Lnet/akehurst/language/api/sppt/SharedPackedParseTree;", "agl-processor"})
public abstract class SyntaxAnalyserAbstract
implements SyntaxAnalyser,
SharedPackedParseTreeVisitor<Object, Object> {
    private GrammarLoader grammarLoader;
    private final Map<String, Function3<SPPTBranch, List<? extends SPPTBranch>, Object, ?>> branchHandlers;

    protected final <T> void register(@NotNull String branchName, @NotNull Function3<? super SPPTBranch, ? super List<? extends SPPTBranch>, Object, ? extends T> handler) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.branchHandlers.put(branchName, handler);
    }

    private final <T> Function3<SPPTBranch, List<? extends SPPTBranch>, Object, T> findBranchHandler(String branchName) {
        Function3 handler;
        Function3 function3 = handler = (Function3)TypeIntrinsics.beforeCheckcastToFunctionOfArity(this.branchHandlers.get(branchName), (int)3);
        if (function3 == null) {
            throw (Throwable)new SyntaxAnalyserException("Cannot find SyntaxAnalyser branch handler method named " + branchName, null);
        }
        return function3;
    }

    protected final <T> T transform(@NotNull SPPTBranch branch, @Nullable Object arg) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        T t = this.transformOpt(branch, arg);
        if (t == null) {
            throw (Throwable)new SyntaxAnalyserException("cannot transform " + branch, null);
        }
        return t;
    }

    @Nullable
    protected final <T> T transformOpt(@Nullable SPPTBranch branch, @Nullable Object arg) {
        return branch == null ? null : (T)branch.accept(this, arg);
    }

    @Override
    @NotNull
    public Object visit(@NotNull SharedPackedParseTree target, @Nullable Object arg) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        SPPTNode root = target.getRoot();
        return root.accept(this, arg);
    }

    @Override
    @NotNull
    public Object visit(@NotNull SPPTLeaf target, @Nullable Object arg) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return target.getMatchedText();
    }

    @Override
    @NotNull
    public Object visit(@NotNull SPPTBranch target, @Nullable Object arg) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String branchName = target.getName();
        Function3 handler = this.findBranchHandler(branchName);
        List<SPPTBranch> branchChildren = target.getBranchNonSkipChildren();
        try {
            return handler.invoke((Object)target, branchChildren, arg);
        }
        catch (Exception e) {
            throw (Throwable)new SyntaxAnalyserException("Exception trying to transform " + target, e);
        }
    }

    public SyntaxAnalyserAbstract() {
        boolean bl = false;
        this.branchHandlers = new LinkedHashMap();
    }
}

