package net.aihelp.utils;

import android.text.TextUtils;
import android.util.Log;

import net.aihelp.BuildConfig;
import net.aihelp.common.SpKeys;

import androidx.annotation.RestrictTo;

@RestrictTo(RestrictTo.Scope.LIBRARY)
public class TLog {

    //打印调试开关
    private static boolean DEBUG = BuildConfig.DEBUG;

    //Log 单词打印的最大长度
    private static final int MAX_LENGTH = 3 * 1024;

    public static void initLog(boolean isDebug) {
        DEBUG = isDebug;
    }

    /**
     * @param tag 可变参数入参，实现可选 TAG
     * @return 最终拼接 TAG: customTag >> (ClassName:lineNumber)
     */
    private static synchronized String getTAG(String... tag) {
        StringBuilder builder = new StringBuilder();
        StackTraceElement[] sts = Thread.currentThread().getStackTrace();
        for (StackTraceElement st : sts) {
            if (!st.isNativeMethod() && !st.getClassName().equals(Thread.class.getName()) &&
                    !st.getClassName().equals(TLog.class.getName())) {
                String customTag = "AIHelp ";
                if (tag != null && tag.length > 0) {
                    customTag = String.format("%s ", tag[0]);
                }
                builder.append(customTag)
                        .append(">> (")
                        .append(st.getFileName()).append(":").append(st.getLineNumber())
                        .append(")");
                return builder.toString();
            }
        }
        return "";
    }

    public static synchronized void e(String text) {
        e("", text);
    }

    public static synchronized void e(String tag, String text) {
        if (DEBUG && !TextUtils.isEmpty(text)) {
            for (String str : splitStr(text)) {
                Log.e(getTAG(tag), str);
            }
        }
    }

    public static synchronized void json(String jsonDescription, String json) {
        if (DEBUG && !TextUtils.isEmpty(json)) {
            String tag = getTAG();
            try {
                //转化后的数据
                String logStr = formatJson(jsonDescription, json);
                for (String str : splitStr(logStr)) {
                    Log.e(getTAG(), str);
                }
            } catch (Exception e) {
                e.printStackTrace();
                Log.e(tag, e.toString());
            }
        }
    }

    private static String[] splitStr(String str) {
        try {
            int length = str.length();
            String[] strArr = new String[length / MAX_LENGTH + 1];
            int start = 0;
            for (int i = 0; i < strArr.length; i++) {
                //判断是否达到最大长度
                if (start + MAX_LENGTH < length) {
                    strArr[i] = str.substring(start, start + MAX_LENGTH);
                    start += MAX_LENGTH;
                } else {
                    strArr[i] = str.substring(start, length);
                    start = length;
                }
            }
            return strArr;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return new String[]{};
    }


    /**
     * 格式化
     *
     * @param jsonStr json数据
     * @return 格式化后的json数据
     * @author lizhgb
     * @link https://my.oschina.net/jasonli0102/blog/517052
     */
    private static String formatJson(String desc, String jsonStr) {
        if (null == jsonStr || "".equals(jsonStr))
            return "";
        StringBuilder sb = new StringBuilder();
        char last = '\0';
        char current = '\0';
        int indent = 0;
        boolean isInQuotationMarks = false;
        for (int i = 0; i < jsonStr.length(); i++) {
            last = current;
            current = jsonStr.charAt(i);
            switch (current) {
                case '"':
                    if (last != '\\') {
                        isInQuotationMarks = !isInQuotationMarks;
                    }
                    sb.append(current);
                    break;
                case '{':
                case '[':
                    if (i == 0) {
                        sb.append("\t\n");
                        sb.append(desc).append(": \n\n");
                    }
                    sb.append(current);
                    if (!isInQuotationMarks) {
                        sb.append('\n');
                        indent++;
                        addIndentBlank(sb, indent);
                    }
                    break;
                case '}':
                case ']':
                    if (!isInQuotationMarks) {
                        sb.append('\n');
                        indent--;
                        addIndentBlank(sb, indent);
                    }
                    sb.append(current);
                    if (i == jsonStr.length() - 1) {
                        sb.append("\n\t");
                    }
                    break;
                case ',':
                    sb.append(current);
                    if (last != '\\' && !isInQuotationMarks) {
                        sb.append('\n');
                        addIndentBlank(sb, indent);
                    }
                    break;
                default:
                    sb.append(current);
            }
        }

        return sb.toString();
    }

    /**
     * 在 StringBuilder指定位置添加 space
     *
     * @param sb     字符集
     * @param indent 添加位置
     * @author lizhgb
     * @link https://my.oschina.net/jasonli0102/blog/517052
     */
    private static void addIndentBlank(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; i++) {
            sb.append('\t');
        }
    }

    public static void l(String url, boolean isTop) {
        if (DEBUG) {
            String tag = getTAG();
            if (isTop) {
//                Log.e(tag, " ");
                //Log.e(tag, "══════════════════════════════════════" + url + " START ══════════════════════════════════════");
            } else {
                //Log.e(tag, "═══════════════════════════════════════" + url + " END ═══════════════════════════════════════");
//                Log.e(tag, " ");
            }
        }
    }

}
