package net.aihelp.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import net.aihelp.config.AIHelpContext;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.core.ui.image.TargetAdapter;
import net.aihelp.ui.helper.BitmapHelper;
import net.aihelp.ui.widget.AIHelpLoadingImageView;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

import androidx.annotation.RestrictTo;
import androidx.core.content.FileProvider;

@RestrictTo(RestrictTo.Scope.LIBRARY)
public class MediaUtils {

    public static final int MEDIA_TYPE_IMAGE = 1;
    public static final int MEDIA_TYPE_VIDEO = 2;
    public static File file;

    public interface OnImageScaledListener {
        void onImageScaled();
    }

    public static void scaleImageView(String source, ImageView targetView, View paramsView, OnImageScaledListener listener) {
        if (targetView == null || paramsView == null || TextUtils.isEmpty(source)) return;
        String adjustedSource = DomainSupportHelper.getAdjustedUrl(source);
        Context context = targetView.getContext();

        Picasso.get().load(adjustedSource).into(new TargetAdapter() {
            @Override
            public void onBitmapLoaded(Bitmap resource, Picasso.LoadedFrom from) {

                Picasso.get().load(adjustedSource).fit().into(targetView);

                ViewGroup.LayoutParams params = paramsView.getLayoutParams();

                int[] size = BitmapHelper.computeSize(resource.getWidth(), resource.getHeight());
                params.width = Math.max(size[0], Styles.dpToPx(context, 50));
                params.height = Math.max(size[1], Styles.dpToPx(context, 50));
                paramsView.setLayoutParams(params);

                if (listener != null) {
                    listener.onImageScaled();
                }
            }
        });

    }

    /**
     * Create a file Uri for saving an image or video
     */
    public static Uri getOutputMediaFileUri(Context context, int type) {
        Uri uri = null;
        //适配Android N
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            return FileProvider.getUriForFile(context, context.getApplicationContext().getPackageName() + ".provider", getOutputMediaFile(type));
        } else {
            return Uri.fromFile(getOutputMediaFile(type));
        }
    }

    /**
     * Create a File for saving an image or video
     */
    public static File getOutputMediaFile(int type) {

        Context context = AIHelpContext.getInstance().getContext();
        if (context != null) {
            File mediaStorageDir = new File(context.getApplicationContext() .getExternalCacheDir() + "/aihelp/image");
            if (!mediaStorageDir.exists()) {
                if (!mediaStorageDir.mkdirs()) {
                    return null;
                }
            }
            // Create a media file name
            File mediaFile;
            if (type == MEDIA_TYPE_IMAGE) {
                mediaFile = new File(mediaStorageDir.getPath() + File.separator +
                        "IMG_" + System.currentTimeMillis() + ".jpg");
            } else if (type == MEDIA_TYPE_VIDEO) {
                mediaFile = new File(mediaStorageDir.getPath() + File.separator +
                        "VID_" + System.currentTimeMillis() + ".mp4");
            } else {
                return null;
            }
            file = mediaFile;
            return mediaFile;
        }
        return null;
    }

    /**
     * 获取视频的第一帧图片
     */
    public static void getImageForVideo(String videoPath, OnLoadVideoImageListener listener) {
        LoadVideoImageTask task = new LoadVideoImageTask(listener);
        task.execute(videoPath);
    }

    public static class LoadVideoImageTask extends AsyncTask<String, Integer, File> {
        private OnLoadVideoImageListener listener;

        public void setOnLoadVideoImageListener(OnLoadVideoImageListener listener) {
            this.listener = listener;
        }

        public LoadVideoImageTask() {
        }

        public LoadVideoImageTask(OnLoadVideoImageListener listener) {
            this.listener = listener;
        }

        @Override
        protected File doInBackground(String... params) {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            String path = params[0];
            if (path.startsWith("http"))
                //获取网络视频第一帧图片
                mmr.setDataSource(path, new HashMap<String, String>());
            else
                //本地视频
                mmr.setDataSource(path);
            Bitmap bitmap = mmr.getFrameAtTime();
            //保存图片
            File f = getOutputMediaFile(MEDIA_TYPE_IMAGE);
            if (f != null && f.exists()) {
                f.delete();
            }
            try {
                FileOutputStream out = new FileOutputStream(f);
                bitmap.compress(Bitmap.CompressFormat.JPEG, 90, out);
                out.flush();
                out.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
            try {
                mmr.release();
            } catch (IOException e) {
                e.printStackTrace();
            }
            return f;
        }

        @Override
        protected void onPostExecute(File file) {
            super.onPostExecute(file);
            if (listener != null) {
                listener.onLoadImage(file);
            }
        }
    }

    public interface OnLoadVideoImageListener {
        void onLoadImage(File file);
    }
}
