package net.aihelp.ui.webkit;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;

import net.aihelp.common.Const;
import net.aihelp.common.IntentValues;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.PageHoppingEvent;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.TLog;
import net.aihelp.utils.ToastUtil;
import net.aihelp.utils.ToastUtil;

import java.net.URISyntaxException;

public class AIHelpWebViewClient extends WebViewClient {

    public static final String TAG = AIHelpWebViewClient.class.getSimpleName();
    private Context context;
    private AIHelpWebProgress webProgress;
    private ShouldOverrideUrlLoadingListener mUrlLoadingListener;
    private OnPageLoadingProgressListener mPageLoadingProgressListener;

    private boolean openInNewWindow;

    public void setOpenInNewWindow(boolean openInNewWindow) {
        this.openInNewWindow = openInNewWindow;
    }

    public void setOnPageLoadingProgressListener(OnPageLoadingProgressListener mPageLoadingProgressListener) {
        this.mPageLoadingProgressListener = mPageLoadingProgressListener;
    }

    public void setUrlLoadingListener(ShouldOverrideUrlLoadingListener mUrlLoadingListener) {
        this.mUrlLoadingListener = mUrlLoadingListener;
    }

    public AIHelpWebViewClient(Context context, AIHelpWebProgress webProgress) {
        this.context = context;
        this.webProgress = webProgress;
    }

    public AIHelpWebViewClient(Context context, AIHelpWebProgress webProgress, boolean openInNewWindow) {
        this.context = context;
        this.webProgress = webProgress;
        this.openInNewWindow = openInNewWindow;
    }

    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        boolean ret = Build.VERSION.SDK_INT >= 24 && this.handleUrlClickAndCancelCurrentLoad(view, request.getUrl().toString()) || super.shouldOverrideUrlLoading(view, request);
        if (mUrlLoadingListener != null) {
            mUrlLoadingListener.handleUrlClickAndCancelCurrentLoad(ret);
        }
        return ret;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        boolean ret = Build.VERSION.SDK_INT < 24 && this.handleUrlClickAndCancelCurrentLoad(view, url) || super.shouldOverrideUrlLoading(view, url);
        if (mUrlLoadingListener != null) {
            mUrlLoadingListener.handleUrlClickAndCancelCurrentLoad(ret);
        }
        return ret;
    }

    @Override
    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        webProgress.show();
        if (mPageLoadingProgressListener != null) {
            mPageLoadingProgressListener.onPageStarted(view, url);
        }
    }

    @Override
    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (mPageLoadingProgressListener != null) {
            mPageLoadingProgressListener.onPageFinished(view, url);
        }
    }

    @SuppressLint("QueryPermissionsNeeded")
    private boolean handleUrlClickAndCancelCurrentLoad(WebView view, String url) {
        if (AppInfoUtil.isUrlStillNeedResponding(context, url)) {
            if (openInNewWindow) {
                Bundle bundle = new Bundle();
                bundle.putString(IntentValues.INTENT_URL, url);
                EventBus.getDefault().post(new PageHoppingEvent(IntentValues.PAGE_HOPPING_FORM, bundle));
                return true;
            }
        }
        // If the url starts with non-http scheme, then current load should be a deep link request.
        // Cancel current load if this is a deep link request,
        // because this should've been handled in AppInfoUtil#isUrlStillNeedResponding()
        boolean isDeepLink = !TextUtils.isEmpty(url) && !url.startsWith("http");

        // If the url contains `js-bridge=enable`, then current load should be a special url.
        // Cancel current load because this should've been handled in AppInfoUtil#isUrlStillNeedResponding()
        boolean isSpecialUrl = !TextUtils.isEmpty(url) && url.contains("js-bridge=enable") && Const.sOnSpecificUrlClickedListener != null;

        return isDeepLink || isSpecialUrl;
    }

    public interface ShouldOverrideUrlLoadingListener {
        void handleUrlClickAndCancelCurrentLoad(boolean result);
    }

    @Override
    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        super.onReceivedSslError(view, handler, error);
        String message;
        switch (error.getPrimaryError()) {
            case SslError.SSL_DATE_INVALID:
                message = "SSL_DATE_INVALID";
                break;
            case SslError.SSL_EXPIRED:
                message = "SSL_EXPIRED";
                break;
            case SslError.SSL_IDMISMATCH:
                message = "SSL_IDMISMATCH";
                break;
            case SslError.SSL_INVALID:
                message = "SSL_INVALID";
                break;
            case SslError.SSL_NOTYETVALID:
                message = "SSL_NOTYETVALID";
                break;
            case SslError.SSL_UNTRUSTED:
                message = "SSL_UNTRUSTED";
                break;
            default:
                message = "SslError unknown";
        }
        Log.d(TAG, "onReceivedSslError: " + message);
    }

    public interface OnPageLoadingProgressListener {
        void onPageStarted(WebView view, String url);

        void onPageFinished(WebView view, String url);
    }

}
