package net.aihelp.ui.webkit;

import android.content.pm.ActivityInfo;
import android.text.TextUtils;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebView;

import net.aihelp.common.Const;

import org.json.JSONObject;

import androidx.fragment.app.Fragment;

public class AIHelpJSBridge {

    private static final String CONFIG_ORIENTATION_AUTO = "1";
    private static final String CONFIG_ORIENTATION_PORTRAIT = "2";
    private static final String CONFIG_ORIENTATION_LANDSCAPE = "3";

    private static final String INTENT_TO_FINISH_PAGE = "closeWebView";
    private static final String INTENT_TO_OPEN_NEW_LINK = "OpenUrlInINTLBrowser";
    private static final String INTENT_TO_SET_FULLSCREEN = "setFullScreen";
    private static final String INTENT_TO_UPDATE_ORIENTATION = "setScreenOrientation";
    private static final String INTENT_TO_CALL_NATIVE_METHOD = "jsCallNative";

    private Fragment fragment;

    public void handleJSMessages(Fragment fragment, WebView webView, String message) {
        this.fragment = fragment;
        try {
            JSONObject jsonObject = new JSONObject(message);
            switch (jsonObject.optString("INTLMethod")) {
                case INTENT_TO_FINISH_PAGE:
                    finishPage();
                    break;
                case INTENT_TO_OPEN_NEW_LINK:
                    openNewLink(webView, jsonObject.optString("ParamKey"));
                    break;
                case INTENT_TO_SET_FULLSCREEN:
                    updateFullScreen(jsonObject.optBoolean("isFullScreen"));
                    break;
                case INTENT_TO_UPDATE_ORIENTATION:
                    updateScreenOrientation(jsonObject.optString("screenOrientation"));
                    break;
                case INTENT_TO_CALL_NATIVE_METHOD:

                    break;
                default:
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void finishPage() {
        if (fragment != null && fragment.getActivity() != null) {
            fragment.getActivity().finish();
        }
    }

    private void openNewLink(WebView webView, String params) {
        try {
            JSONObject jsonObject = new JSONObject(params);
            if (!TextUtils.isEmpty(jsonObject.optString("url"))) {
                webView.loadUrl(jsonObject.optString("url"));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateFullScreen(boolean isFullScreen) {
        if (fragment != null && fragment.getActivity() != null) {
            Window window = fragment.getActivity().getWindow();
            window.setFlags(
                    isFullScreen ? WindowManager.LayoutParams.FLAG_FULLSCREEN : WindowManager.LayoutParams.FLAG_FORCE_NOT_FULLSCREEN,
                    WindowManager.LayoutParams.FLAG_FULLSCREEN
            );
        }
    }

    private void updateScreenOrientation(String targetOrientation) {
        int orientation = ActivityInfo.SCREEN_ORIENTATION_SENSOR;
        if (CONFIG_ORIENTATION_PORTRAIT.equals(targetOrientation)) {
            orientation = ActivityInfo.SCREEN_ORIENTATION_PORTRAIT;
        } else if (CONFIG_ORIENTATION_LANDSCAPE.equals(targetOrientation)) {
            orientation = ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE;
        }
        if (fragment != null && fragment.getActivity() != null) {
            fragment.getActivity().setRequestedOrientation(orientation);
        }
    }

    public void callJs(String json) {
        StringBuilder jsHandler = new StringBuilder("INTLJSHandler");
        jsHandler.append("('").append(json).append("')");

    }

    public static AIHelpJSBridge getInstance() {
        return AIHelpJSBridge.Holder.INSTANCE;
    }

    private static class Holder {
        private static final AIHelpJSBridge INSTANCE = new AIHelpJSBridge();
    }
}
