package net.aihelp.ui.task.detail;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.common.IntentValues;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.luban.Luban;
import net.aihelp.core.util.luban.OnCompressListener;
import net.aihelp.core.util.permission.AIHelpPermissions;
import net.aihelp.core.util.permission.IPermissionCallback;
import net.aihelp.core.util.permission.Permission;
import net.aihelp.core.util.viewer.ImageViewer;
import net.aihelp.data.event.SearchViewVisibilityChangeEvent;
import net.aihelp.data.event.UpdateTitleEvent;
import net.aihelp.data.logic.TaskDetailPresenter;
import net.aihelp.data.model.task.ReplyMessage;
import net.aihelp.data.model.task.TaskDetailEntity;
import net.aihelp.ui.adapter.task.detail.TaskReplyListAdapter;
import net.aihelp.ui.helper.AttachmentPicker;
import net.aihelp.ui.helper.AttachmentPickerFile;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.ui.widget.StepView;
import net.aihelp.ui.widget.snackbar.Snackbar;
import net.aihelp.utils.DateFormatUtil;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.MediaUtils;
import net.aihelp.utils.RegexDefinition;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.RichTextSlicer;
import net.aihelp.utils.Styles;
import net.aihelp.utils.ToastUtil;
import net.aihelp.utils.UploadFileHelper;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class TaskDetailFragment extends BaseFragment<TaskDetailPresenter> implements View.OnClickListener,
        TaskReplyListAdapter.OnReplyEventListener, TaskReplyComposer.OnUserReplyListener {

    private TaskReplyComposer replyComposer;

    private StepView stepView;
    private TaskReplyListAdapter replyListAdapter;
    private TextView tvTaskTime;
    private LinearLayout llTaskContent;
    private AIHelpButton btnReply;

    private String taskCode;

    public static TaskDetailFragment newInstance(Bundle bundle) {
        TaskDetailFragment faqFragment = new TaskDetailFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void getBundleBeforeDataPrepared(Bundle extras) {
        EventBus.getDefault().post(new SearchViewVisibilityChangeEvent(false));
        taskCode = extras.getString(IntentValues.TASK_CODE, "");
    }

    @Override
    public void onResume() {
        super.onResume();
        EventBus.getDefault().post(new UpdateTitleEvent(UpdateTitleEvent.CUSTOM_SERVICE, null,
                ResResolver.getString("aihelp_my_task")));
    }

    @Override
    protected void initEventAndData(View view) {
        replyComposer = new TaskReplyComposer();

        RelativeLayout rlStatusContainer = get("aihelp_rl_status");
        TextView tvStatusTitle = get("aihelp_tv_status_title");
        stepView = get("aihelp_step_view");

        RelativeLayout rlReplyContainer = get("aihelp_rl_reply");
        TextView tvReplyTitle = get("aihelp_tv_reply_title");
        RecyclerView rvReply = get("aihelp_rv_reply");
        btnReply = get("aihelp_btn_reply");

        RelativeLayout rlTaskContainer = get("aihelp_rl_task");
        TextView tvTaskTitle = get("aihelp_tv_task_title");
        tvTaskTime = get("aihelp_tv_task_time");
        llTaskContent = get("aihelp_ll_task_content");

        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                CustomConfig.CommonSetting.upperBackgroundAlpha);
        rlStatusContainer.setBackground(Styles.getDrawable(colorFromHex, 0));
        rlReplyContainer.setBackground(Styles.getDrawable(colorFromHex, 0));
        rlTaskContainer.setBackground(Styles.getDrawable(colorFromHex, 0));

        int textColor = Color.parseColor(CustomConfig.CommonSetting.textColor);
        Styles.reRenderTextView(tvStatusTitle, ResResolver.getString("aihelp_task_status"), textColor);
        Styles.reRenderTextView(tvReplyTitle, ResResolver.getString("aihelp_reply_content"), textColor);
        Styles.reRenderTextView(tvTaskTitle, ResResolver.getString("aihelp_task_content"), textColor);

        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(getContext()) {
            @Override
            public boolean canScrollVertically() {
                return false;
            }
        };
        linearLayoutManager.setReverseLayout(true);
        rvReply.setLayoutManager(linearLayoutManager);
        replyListAdapter = new TaskReplyListAdapter(getContext());
        replyListAdapter.setOnReplyEventListener(this);
        rvReply.setAdapter(replyListAdapter);

        btnReply.useSmallSize().setText(ResResolver.getString("aihelp_reply"));
        btnReply.setOnClickListener(this);

        mPresenter.requestTaskContent(taskCode);
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_task_detail");
    }

    public void refreshTaskContent(TaskDetailEntity entity, List<ReplyMessage> replyList) {
        stepView.update(
                entity.getStatusList(),
                entity.getStatus(),
                CustomConfig.CommonSetting.interactElementTextColor
        );
        btnReply.setVisibility(stepView.isFinished() ? View.GONE : View.VISIBLE);

        Styles.reRenderTextView(tvTaskTime, DateFormatUtil.dateFormat(entity.getCreateTime(), null));
        llTaskContent.addView(RichTextSlicer.getRichTextView(getContext(), entity.getContent()));

        replyListAdapter.update(replyList);
    }

    @Override
    public void onRetrySendingMessage(int position, ReplyMessage replyMessage) {
        // Only remove item when we're resending the message after a failed sending
        // If the resending succeed, the reply message will be updated to NORMAL status,
        // and the following logic will update the message
        if (replyMessage.getMsgStatus() == ReplyMessage.STATUS_SENDING) {
            replyListAdapter.remove(position);
        }
        onUserReply(replyMessage);
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == ResResolver.getViewId("aihelp_btn_reply")) {
            replyComposer.showReplyComposer(this, getContext());
            replyComposer.setOnUserReplyListener(this);
        }
    }

    @Override
    public void onUserReply(ReplyMessage replyMessage) {
        if (replyMessage.getMsgType() == ReplyMessage.MSG_TYPE_IMAGE
                || replyMessage.getMsgType() == ReplyMessage.MSG_TYPE_VIDEO) {
            if (replyMessage.getMsgStatus() == ReplyMessage.STATUS_SENDING) {
                replyListAdapter.update(replyMessage);
            } else {
                for (int i = replyListAdapter.getDataList().size() - 1; i >= 0; i--) {
                    ReplyMessage msg = replyListAdapter.getDataList().get(i);
                    if (msg.getTimeStamp() == replyMessage.getTimeStamp()) {
                        msg.setMsgStatus(replyMessage.getMsgStatus() == ReplyMessage.STATUS_NORMAL
                                ? ReplyMessage.STATUS_NORMAL : ReplyMessage.STATUS_FAILURE);
                        replyListAdapter.notifyItemChanged(i);
                        break;
                    }
                }
            }
        } else {
            replyListAdapter.update(replyMessage);
        }

        if (replyMessage.getMsgStatus() == ReplyMessage.STATUS_NORMAL) {
            mPresenter.onUserReply(taskCode, replyMessage.getContent(), replyMessage.getReplyFormat());
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        UploadFileHelper.INSTANCE.setOnUploadFileListener(null);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        AIHelpPermissions.getInstance().onRequestPermissionsResult(permissions, grantResults);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        if (intent != null && resultCode == Activity.RESULT_OK) {
            AttachmentPicker.getInstance().onAttachmentPickRequestResult(requestCode, intent);
        }
    }

}
