package net.aihelp.ui.helper;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;


import net.aihelp.common.IntentValues;
import net.aihelp.core.net.mqtt.config.MqttConfig;

import net.aihelp.ui.cs.ConversationFragment;
import net.aihelp.ui.cs.ElvaBotFragment;
import net.aihelp.ui.cs.IntentUrlFragment;
import net.aihelp.ui.faq.FaqContentFragment;
import net.aihelp.ui.faq.FaqListFragment;
import net.aihelp.ui.faq.FaqSearchFragment;
import net.aihelp.ui.faq.FaqHomeFragment;
import net.aihelp.ui.op.OperationFragment;
import net.aihelp.ui.op.OperateContentFragment;
import net.aihelp.ui.task.detail.TaskDetailFragment;
import net.aihelp.ui.task.TaskListFragment;
import net.aihelp.ui.wrapper.FaqEventListenerWrapper;
import net.aihelp.utils.ResResolver;

import java.util.concurrent.atomic.AtomicBoolean;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;


public class SupportHelper extends FaqEventListenerWrapper {

    private final Context context;
    private final FragmentManager childFragmentManager;
    private final Bundle bundle;
    private final AtomicBoolean isSupportStarted = new AtomicBoolean();

    private int supportMode;

    public SupportHelper(Context context, FragmentManager childFragmentManager, Bundle bundle) {
        this.context = context;
        this.childFragmentManager = childFragmentManager;
        this.bundle = bundle;
    }

    public void start() {
        if (!isSupportStarted.get()) {
            supportMode = bundle.getInt(IntentValues.SUPPORT_MODE, 0);
            switch (supportMode) {
                case IntentValues.MODE_ELVA:
                    startElva(bundle, false);
                    break;
                case IntentValues.MODE_CONVERSATION:
                    startConversation(bundle, false);
                    break;
                case IntentValues.MODE_SHOW_SECTION:
                    onIntentToShowSection(bundle);
                    break;
                case IntentValues.MODE_SHOW_SINGLE_FAQ:
                    onIntentToQuestionContent(bundle);
                    break;
                case IntentValues.MODE_OPERATE:
                    onIntentToOperate(bundle);
                    break;
                case IntentValues.MODE_URL:
                    onIntentToFillForm(bundle, false);
                    break;
                default:
                    onIntentToSectionRoot(bundle, false);
                    break;
            }
            isSupportStarted.set(true);
        }
    }


    public void onIntentToElvaBot(Bundle bundle){
        startElva(bundle, true);
    }

    public void onIntentToConversation(Bundle bundle){
        startConversation(bundle, true);
    }

    public void onIntentToSectionRoot(Bundle bundle, boolean isAddToBackStack) {
        Fragment faqFragment;
        String backStackName = null;
        faqFragment = FaqHomeFragment.newInstance(bundle);
        if (isAddToBackStack) {
            backStackName = faqFragment.getClass().getName();
        }
        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"),
                faqFragment, null, backStackName, false, false);
    }

    private void onIntentToShowSection(Bundle bundle) {
        String sectionId = bundle.getString(IntentValues.SECTION_ID, "");
        if (TextUtils.isEmpty(sectionId)) {
            onIntentToSectionRoot(bundle, false);
            return;
        }
        onIntentToQuestionList(bundle);
    }

    public void onIntentToTicketList(Bundle bundle) {
        Fragment fragment = TaskListFragment.newInstance(bundle);
        String backStackName = fragment.getClass().getName();
        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"),
                fragment, null, backStackName, false, false);

    }

    public void onIntentToTicketContent(Bundle bundle) {
        Fragment fragment = TaskDetailFragment.newInstance(bundle);
        String backStackName = fragment.getClass().getName();
        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"),
                fragment, null, backStackName, false, false);

    }

    @Override
    public void onIntentToSectionList(Bundle bundle) {
        FaqHomeFragment fraSectionList = FaqHomeFragment.newInstance(bundle);
        boolean shouldShowRootSection = bundle.getString(IntentValues.SECTION_ID) == null;
        if (shouldShowRootSection) {
            FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_faq_root"),
                    fraSectionList, null, null,
                    false, false);
        } else {
            FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"),
                    fraSectionList, null, bundle.getString(IntentValues.SECTION_ID),
                    false, false);
        }
    }

    @Override
    public void onIntentToQuestionList(Bundle bundle) {
        String sectionId = bundle.getString(IntentValues.SECTION_ID);
        FaqListFragment fraQuestionList = FaqListFragment.newInstance(bundle);
        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"),
                fraQuestionList, "", getBackStackName(fraQuestionList.getClass().getName()),
                false, false);

    }

    @Override
    public void onIntentToQuestionContent(Bundle bundle) {
        String faqId = bundle.getString(IntentValues.FAQ_MAIN_ID);
        FaqContentFragment fraQuestionContent = FaqContentFragment.newInstance(bundle);
        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"),
                fraQuestionContent, "", getBackStackName(fraQuestionContent.getClass().getName()),
                true, false);
    }

    @Override
    public void onIntentToSearch(Bundle bundle) {
        Configuration configuration = context.getResources().getConfiguration();
        int fragmentContainerId;
//        if (configuration.orientation == Configuration.ORIENTATION_PORTRAIT) {
//            fragmentContainerId = ResResolver.getViewId("aihelp_faq_root");
//        } else {
//            fragmentContainerId = ResResolver.getViewId("aihelp_support_fragment_container");
//        }
//        fragmentContainerId = ResResolver.getViewId("aihelp_root_container");
        fragmentContainerId = ResResolver.getViewId("aihelp_support_fragment_container");
        FaqSearchFragment fraSearchFaq = FaqSearchFragment.newInstance(bundle);
        FragmentHelper.startFragment(childFragmentManager, fragmentContainerId,
                fraSearchFaq, "tag_faq_search", fraSearchFaq.getClass().getName(), false, false);
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {

    }

    @Override
    public void afterTextChanged(Editable s) {

    }

    @Override
    public void onTextChanged(final CharSequence s, int start, int before, int count) {
        FaqSearchFragment searchFragment = (FaqSearchFragment) this.childFragmentManager.findFragmentByTag("tag_faq_search");
        if (searchFragment != null) {
            searchFragment.onQuery(String.valueOf(s).trim());
        }
    }

    private Fragment getTopMostFaqFragment() {
        return FragmentHelper.getTopMostFragment(this.childFragmentManager);
    }

    private String getBackStackName(String backStackName) {

        if (supportMode == IntentValues.MODE_SHOW_SECTION) {
            if (backStackName.equals(FaqContentFragment.class.getName())) {
                return backStackName;
            }
            return "";
        }

        if (supportMode == IntentValues.MODE_SHOW_SINGLE_FAQ) {
            return "";
        }

        // 默认情况下，加入回退栈
        return backStackName;
    }

    public void startElva(Bundle bundle, boolean isAddToBackStack) {
        if (MqttConfig.getInstance().isConnected()) return;
        Fragment elvaBot = ElvaBotFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = elvaBot.getClass().getName();
        }
        FragmentHelper.startFragment(childFragmentManager,
                ResResolver.getViewId("aihelp_support_fragment_container"), elvaBot,
                backStackName, backStackName, false, false);
    }

    public void startConversation(Bundle bundle, boolean isAddToBackStack) {
        Fragment conversationFragment = ConversationFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = conversationFragment.getClass().getName();
        }
        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), conversationFragment,
                backStackName, backStackName, false, false);
    }

    @Override
    public void onIntentToFillForm(Bundle bundle, boolean isAddToBackStack) {
        IntentUrlFragment formFragment = IntentUrlFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = formFragment.getClass().getName();
        }
        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), formFragment,
                backStackName, backStackName, false, false);
    }

    private void onIntentToOperate(Bundle bundle) {
        OperationFragment operateFragment = OperationFragment.newInstance(bundle);
        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"),
                operateFragment, null, null,
                false, false);
    }

    @Override
    public void onIntentToOperateContent(Bundle bundle) {
        OperateContentFragment fraOperateContent = OperateContentFragment.newInstance(bundle);
        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"),
                fraOperateContent, "fraOperateContent", fraOperateContent.getClass().getName(),
                true, false);
    }

}
