package net.aihelp.ui.helper;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.model.cs.storyline.BotOrderInfo;
import net.aihelp.ui.adapter.BillingListAdapter;
import net.aihelp.ui.cs.ElvaFaqBottomSheetEvent;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import org.json.JSONArray;
import org.json.JSONObject;

import androidx.core.content.ContextCompat;

public class SendingBillHelper implements View.OnClickListener {

    private SendingBillHelper() {

    }

    private static SendingBillHelper sInstance;

    public static SendingBillHelper getInstance() {
        if (sInstance == null) {
            sInstance = new SendingBillHelper();
        }
        return sInstance;
    }

    private AlertDialog billSelectDialog;

    private TextView mTvSend;
    private ImageView mIvClose;
    private RelativeLayout mEmptyLayout;
    private ProgressBar progressBar;

    private ListView mBillList;
    private BillingListAdapter mAdapter;

    private BotOrderInfo botOrderInfo;

    public void readyToSelectBill(Context context, BotOrderInfo orderInfo) {

        this.botOrderInfo = orderInfo;

        billSelectDialog = new AlertDialog.Builder(context)
                .setContentView(ResResolver.getLayoutId("aihelp_dia_selecting_bill"))
                .setGravity(Gravity.BOTTOM)
                .fromBottom(true)
                .setCancelableOntheOutside(true)
                .setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialog) {
                        EventBus.getDefault().unregister(SendingBillHelper.this);
                    }
                })
                .setWidthAndHeight(ViewGroup.LayoutParams.MATCH_PARENT, 500)
                .setHeightByDevice()
                .create();

        LinearLayout llRoot = billSelectDialog.findViewById(ResResolver.getViewId("aihelp_ll_bill_dialog"));
        llRoot.setBackgroundColor(Styles.getColor(CustomConfig.CommonSetting.upperBackgroundColor));

        // Send
        mTvSend = billSelectDialog.findViewById(ResResolver.getViewId("aihelp_tv_send"));
        Styles.reRenderTextView(mTvSend, ResResolver.getString("aihelp_send"),
                Styles.getColor(CustomConfig.CommonSetting.interactElementTextColor));
        mTvSend.setOnClickListener(this);

        // Close
        mIvClose = billSelectDialog.findViewById(ResResolver.getViewId("aihelp_iv_close"));
        Styles.reRenderImageView(mIvClose, "aihelp_svg_ic_close_dialog");
        mIvClose.setOnClickListener(this);

        // Empty Layout
        mEmptyLayout = billSelectDialog.findViewById(ResResolver.getViewId("aihelp_rl_empty"));

        // Progressbar
        progressBar = billSelectDialog.findViewById(ResResolver.getViewId("aihelp_loading_progress"));
        Drawable drawable = progressBar.getIndeterminateDrawable().mutate();
        drawable.setColorFilter(Styles.getColor(CustomConfig.CommonSetting.interactElementTextColor), PorterDuff.Mode.SRC_IN);
        progressBar.setIndeterminateDrawable(drawable);
        progressBar.setVisibility(View.VISIBLE);

        // ListView
        mBillList = billSelectDialog.findViewById(ResResolver.getViewId("aihelp_lv_bill"));
        mAdapter = new BillingListAdapter(context, mBillList);
        mAdapter.setOnOrderCheckedListener(new BillingListAdapter.OnOrderCheckedListener() {
            @Override
            public void onOrderChecked() {
                mTvSend.setEnabled(true);
                mTvSend.setAlpha(1.0f);
            }
        });
        mBillList.setAdapter(mAdapter);
        billSelectDialog.show();

        // Request data
        requestBillList(context, orderInfo);
        EventBus.getDefault().register(SendingBillHelper.this);
    }

    private void requestBillList(Context context, BotOrderInfo orderInfo) {
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("id", orderInfo.getId());
            jsonObj.put("userId", UserProfile.USER_ID);
            jsonObj.put("serverId", UserProfile.SERVER_ID);
            jsonObj.put("applicationIdentifier", context.getPackageName());
            if (!TextUtils.isEmpty(orderInfo.getUrl())) {
                AIHelpRequest.getInstance().requestPostByJson(orderInfo.getUrl(), jsonObj, new ReqCallback<String>() {
                    @Override
                    public void onReqSuccess(String result) {
                        progressBar.setVisibility(View.GONE);
                        try {
                            JSONObject resJsonObject = new JSONObject(result);

                            Const.TOGGLE_SHEET_DIALOG_ENABLE_INTERACTION = resJsonObject.optBoolean("enableInteraction");
                            mTvSend.setVisibility(Const.TOGGLE_SHEET_DIALOG_ENABLE_INTERACTION ? View.VISIBLE : View.GONE);
                            mIvClose.setVisibility(Const.TOGGLE_SHEET_DIALOG_ENABLE_INTERACTION ? View.GONE : View.VISIBLE);

                            JSONArray jsonArray = new JSONArray(resJsonObject.optString("list"));
                            if (jsonArray.length() > 0) {
                                mAdapter.update(jsonArray);
                            } else {
                                showEmpty(false);
                            }
                        } catch (Exception e) {
                            // ignored
                        }
                    }

                    @Override
                    public void onFailure(String url, int errorCode, String errorMsg) {
                        progressBar.setVisibility(View.GONE);
                        showEmpty(true);
                    }
                });
            } else {
                showEmpty(true);
            }
        } catch (Exception e) {
            // ignored
        }
    }

    private void showEmpty(boolean isError) {
        mTvSend.setVisibility(View.GONE);
        mIvClose.setVisibility(View.GONE);
        mEmptyLayout.setVisibility(View.VISIBLE);
        TextView tvError = mEmptyLayout.findViewById(ResResolver.getViewId("aihelp_tv_error_desc"));
        tvError.setText(isError ? ResResolver.getString("aihelp_data_retrieve_failed") :
                ResResolver.getString("aihelp_data_not_found_msg"));
    }

    @Override
    public void onClick(View v) {

        if (v.getId() == ResResolver.getViewId("aihelp_tv_send") && FastClickValidator.validate()) {
            if (AppInfoUtil.validateNetwork(v.getContext())) {
                String checkedBillJson = mAdapter.getCheckedBill();
                if (!TextUtils.isEmpty(checkedBillJson)) {
                    try {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("userId", UserProfile.USER_ID);
                        jsonObject.put("userName", UserProfile.USER_NAME);
                        jsonObject.put("serverId", UserProfile.SERVER_ID);
                        jsonObject.put("message", checkedBillJson);
                        if (botOrderInfo != null) {
                            jsonObject.put("externalName", botOrderInfo.getName());
                        }
                        AIHelpRequest.getInstance().requestPostByJson(API.GENERATE_NEW_TICKET, jsonObject, null);
                    } catch (Exception e) {
                        // ignored
                    }
                }
                if (billSelectDialog != null && billSelectDialog.isShowing()) {
                    billSelectDialog.dismiss();
                }
            }
        }

        if (v.getId() == ResResolver.getViewId("aihelp_iv_close") && FastClickValidator.validate()) {
            if (billSelectDialog != null && billSelectDialog.isShowing()) {
                billSelectDialog.dismiss();
            }
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onEventComing(OrientationChangeEvent event) {
        if (billSelectDialog != null && billSelectDialog.isShowing()) {
            billSelectDialog.dismiss();
        }
    }

}
