package net.aihelp.ui.helper;

import android.os.Build;
import android.text.TextUtils;

import net.aihelp.BuildConfig;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.util.logger.AIHelpLogger;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.TLog;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.IOException;

import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;

public class MessageSyncHelper {

    public static void syncLogMessage() {
        try {
            JSONArray cachedLogs = AIHelpLogger.INSTANCE.getCachedLogs();
            if (cachedLogs.length() > 0) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("deviceModel", Build.MODEL);
                jsonObject.put("gameVersion", AppInfoUtil.getAppVersion(AIHelpContext.getInstance().getContext()));
                jsonObject.put("userId", UserProfile.USER_ID);
                jsonObject.put("deviceId", DeviceUuidFactory.id(AIHelpContext.getInstance().getContext()));
                jsonObject.put("sdkVersion", BuildConfig.SDK_VERSION);
                jsonObject.put("logs", cachedLogs);
                AIHelpRequest.getInstance().requestPostByJson(API.TRACK_EXCEPTION, jsonObject, new ReqCallback<String>() {
                    @Override
                    public void onAsyncReqSuccess(String result) {
                        AIHelpLogger.INSTANCE.deleteAllCachedLogs();
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
