package net.aihelp.ui.helper;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;

import net.aihelp.BuildConfig;
import net.aihelp.common.Const;
import net.aihelp.config.AIHelpContext;
import net.aihelp.utils.DeviceInfoUtil;
import net.aihelp.utils.Styles;
import net.aihelp.utils.TLog;


public class BitmapHelper {

    public static int[] computeSize(int realWidth, int realHeight) {
        Context context = AIHelpContext.getInstance().getContext();
        int[] size = new int[2];
        double scale;
        if (realWidth > realHeight) {
            scale = realWidth * 1.0f / BitmapHelper.getImageMaxWidth();
        } else {
            scale = realHeight * 1.0f / Styles.dpToPx(context, 200);
        }
        if (scale < 1) scale = 1;

        size[0] = Math.max((int) (realWidth / scale), Styles.dpToPx(context, 50));
        size[1] = Math.max((int) (realHeight / scale), Styles.dpToPx(context, 50));

        if (BuildConfig.DEBUG) {
            TLog.e(String.format("%s -> %s", realWidth + "x" + realHeight, size[0] + "x" + size[1]));
        }
        return size;
    }

    public static int[] computeSize(String path) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile(path, options);
        return computeSize(options.outWidth, options.outHeight);
    }

    public static int getImageMaxWidth() {
        Context context = AIHelpContext.getInstance().getContext();
        int widthPixels = context.getResources().getDisplayMetrics().widthPixels;
        int heightPixels = context.getResources().getDisplayMetrics().heightPixels;
        return Math.min(widthPixels, heightPixels) - (Styles.dpToPx(context, 40) + Styles.dpToPx(context, 20)) * 2;
    }

    /**
     * 根据给定的宽和高进行拉伸
     *
     * @param origin    原图
     * @param newWidth  新图的宽
     * @param newHeight 新图的高
     * @return new Bitmap
     */
    public static Bitmap scaleBitmap(Bitmap origin, int newWidth, int newHeight) {
        if (origin == null) {
            return null;
        }
        try {
            int width = origin.getWidth();
            int height = origin.getHeight();
            float scaleWidth = ((float) newWidth) / width;
            float scaleHeight = ((float) newHeight) / height;
            Matrix matrix = new Matrix();
            matrix.postScale(0.8f, 0.9f);// 使用后乘
            Bitmap newBM = Bitmap.createBitmap(origin, 0, 0, width, height, matrix, false);
//            if (!origin.isRecycled()) {
//                origin.recycle();
//            }
            return newBM;
        } catch (Exception e) {
            return origin;
        }
    }

    /**
     * 按比例缩放图片
     *
     * @param origin 原图
     * @param ratio  比例
     * @return 新的bitmap
     */
    public static Bitmap scaleBitmap(Bitmap origin, float ratio) {
        if (origin == null) {
            return null;
        }
        int width = origin.getWidth();
        int height = origin.getHeight();
        Matrix matrix = new Matrix();
        matrix.preScale(ratio, ratio);
        Bitmap newBM = Bitmap.createBitmap(origin, 0, 0, width, height, matrix, false);
        if (newBM.equals(origin)) {
            return newBM;
        }
        return newBM;
    }

    /**
     * 裁剪
     *
     * @param bitmap 原图
     * @return 裁剪后的图像
     */
    public static Bitmap cropBitmap(Bitmap bitmap) {
        int w = bitmap.getWidth(); // 得到图片的宽，高
        int h = bitmap.getHeight();
        int cropWidth = w >= h ? h : w;// 裁切后所取的正方形区域边长
        cropWidth /= 2;
        int cropHeight = (int) (cropWidth / 1.2);
        return Bitmap.createBitmap(bitmap, w / 3, 0, cropWidth, cropHeight, null, false);
    }

    /**
     * 裁剪
     *
     * @param bitmap 原图
     * @return 裁剪后的图像
     */
    public static Bitmap cropBitmap(Bitmap bitmap, int targetWidth, int targetHeight, boolean cropInCenterY) {

        if (targetWidth <= 0 || targetHeight <= 0) return bitmap;

        int bitmapWidth = bitmap.getWidth(); // 得到图片的宽，高
        int bitmapHeight = bitmap.getHeight();

        int startX = 0;
        if (bitmapWidth > targetWidth) {
            startX = (bitmapWidth - targetWidth) / 2;
        }

        int startY = 0;
        if (cropInCenterY && bitmapHeight > targetHeight) {
            startY = (bitmapHeight - targetHeight) / 2;
        }

        if (startX + targetWidth > bitmapWidth || startY + targetHeight > bitmapHeight) {
            return bitmap;
        }

        return Bitmap.createBitmap(bitmap, startX, startY, targetWidth, targetHeight, null, false);
    }

    public static Bitmap cropBitmapToFitTarget(Bitmap bitmap, View targetView) {
        if (targetView == null) return bitmap;
        return cropBitmap(bitmap, targetView.getWidth(), targetView.getHeight(), false);
    }

    public static Bitmap cropBitmapToFitDevice(Bitmap bitmap) {
        Context context = AIHelpContext.getInstance().getContext();
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        int targetWidth = metrics.widthPixels;
        int targetHeight = metrics.heightPixels;
        return cropBitmap(bitmap, targetWidth, targetHeight, false);
    }

}
