package net.aihelp.ui.helper;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.OpenableColumns;
import android.text.TextUtils;

import net.aihelp.config.AIHelpContext;
import net.aihelp.core.util.permission.PermissionHelper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.UUID;

public class AttachmentHelper {

    public static final int PICK_IMAGE = 1;
    public static final int PICK_VIDEO = 2;

    public static AttachmentPickerFile createPickFileFromUri(Uri uri) {
        Context context = AIHelpContext.getInstance().getContext();
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = contentResolver.query(uri, null, null, null, null);
        Long size = null;
        String displayName = null;
        String mime = null;

        try {
            if (cursor != null && cursor.moveToFirst()) {
                int columnIndex = cursor.getColumnIndex(OpenableColumns.DISPLAY_NAME);
                if (columnIndex >= 0) {
                    displayName = cursor.getString(columnIndex);
                }
                mime = contentResolver.getType(uri);
                if (TextUtils.isEmpty(displayName)) {
                    displayName = UUID.randomUUID().toString();
                }

                int sizeIndex = cursor.getColumnIndex(OpenableColumns.SIZE);
                if (!cursor.isNull(sizeIndex)) {
                    String sizeString = cursor.getString(sizeIndex);
                    if (sizeString != null) {
                        try {
                            size = Long.valueOf(sizeString);
                        } catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }

        AttachmentPickerFile attachmentPickerFile = new AttachmentPickerFile(uri, displayName, size);
        attachmentPickerFile.filePath = copyAndGetFilePath(context, uri);
        attachmentPickerFile.isFileCompressionAndCopyingDone = attachmentPickerFile.filePath != null;

        if (mime != null && mime.startsWith("video/")) {
            attachmentPickerFile.attachmentType = PICK_VIDEO;
        } else {
            attachmentPickerFile.attachmentType = PICK_IMAGE;
        }

        return attachmentPickerFile;
    }

    public static String copyAndGetFilePath(Context context, Uri uri) {
        try {
            String displayName = UUID.randomUUID().toString();
            Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                int columnIndex = cursor.getColumnIndex(OpenableColumns.DISPLAY_NAME);
                if (columnIndex >= 0) {
                    displayName = cursor.getString(columnIndex);
                }
            }
            File file = new File(context.getCacheDir(), displayName);
            if (file.exists()) {
                return file.getPath();
            }

            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            FileOutputStream outputStream = new FileOutputStream(file);
            int read = 0;
            final byte[] buffers = new byte[8192];
            while ((read = inputStream.read(buffers)) != -1) {
                outputStream.write(buffers, 0, read);
            }
            if (cursor != null) cursor.close();
            inputStream.close();
            outputStream.close();
            return file.getPath();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

}
