package net.aihelp.ui.cs;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;

import net.aihelp.common.IntentValues;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.permission.AIHelpPermissions;
import net.aihelp.core.util.permission.IPermissionCallback;
import net.aihelp.core.util.permission.Permission;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.ui.helper.AttachmentDataProvider;
import net.aihelp.ui.webkit.AIHelpWebChromeClient;
import net.aihelp.ui.webkit.AIHelpWebProgress;
import net.aihelp.ui.webkit.AIHelpWebView;
import net.aihelp.ui.webkit.AIHelpWebViewClient;
import net.aihelp.ui.widget.snackbar.Snackbar;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.TLog;
import net.aihelp.utils.ToastUtil;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class IntentUrlFragment extends BaseFragment {

    private AIHelpWebView mWebView;
    private AIHelpWebChromeClient mClient;

    public static IntentUrlFragment newInstance(Bundle bundle) {
        IntentUrlFragment formFragment = new IntentUrlFragment();
        formFragment.setArguments(bundle);
        return formFragment;
    }

    @SuppressLint({"JavascriptInterface", "AddJavascriptInterface"})
    @Override
    protected void initEventAndData(View view) {

        AIHelpWebProgress progressBar = (AIHelpWebProgress) get("aihelp_progress_bar");
        mClient = new AIHelpWebChromeClient(this, progressBar);

        mWebView = (AIHelpWebView) get("aihelp_web_view");
        mWebView.setBackgroundColor(Color.TRANSPARENT);
        mWebView.setWebViewClient(new AIHelpWebViewClient(getContext(), progressBar));
        mWebView.setWebChromeClient(mClient);

        if (getActivity() != null && mWebView != null) {
            mWebView.addJavascriptInterface(getActivity(), "android");
        }
    }

    @Override
    protected void getBundleAfterDataPrepared(Bundle extras) {
        String intentUrl = extras.getString(IntentValues.INTENT_URL);
        if (mWebView != null) mWebView.loadUrl(DomainSupportHelper.getAdjustedUrl(intentUrl));
        TLog.e("Intent URL is " + DomainSupportHelper.getAdjustedUrl(intentUrl));
    }

    @Override
    public void onResume() {
        super.onResume();
        EventBus.getDefault().post(new SupportActionEvent(IntentValues.HIDE_SUPPORT_ACTION));
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_intent_url");
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (mClient != null) {
            mClient.onActivityResult(requestCode, resultCode, data);
        }
    }

    public boolean onBackPressed() {
        if (mWebView != null && mWebView.canGoBack()) {
            mWebView.goBack();
            return false;
        }
        return true;
    }

    @Permission(requestCode = Permission.REQUEST_CODE_FORM)
    public void onPermissionRequested(Permission.Result result, final IPermissionCallback callback) {
        switch (result) {
            case GRANTED:
                startActivityForResult(AttachmentDataProvider.getIntentForMedia(true), AIHelpWebChromeClient.REQUEST_CODE);
                break;
            case DENIED:
                if (mClient != null) mClient.cancelChooseFileDialog();
                ToastUtil.INSTANCE.showRawSnackBar(getActivity(), ResResolver.getString("aihelp_permission_denied"), Snackbar.LENGTH_SHORT);
                break;
            case RATIONAL:
                if (mClient != null) mClient.cancelChooseFileDialog();
                ToastUtil.INSTANCE.showRawSnackBar(getActivity(), ResResolver.getString("aihelp_permission_denied"),
                        ResResolver.getString("aihelp_yes"), Snackbar.LENGTH_INDEFINITE, new View.OnClickListener() {
                            @Override
                            public void onClick(View v) {
                                callback.onPermissionRational();
                            }
                        });
                break;
            case GO_SETTING:
                if (mClient != null) mClient.cancelChooseFileDialog();
                ToastUtil.INSTANCE.showRawSnackBar(getActivity(), ResResolver.getString("aihelp_permission_ignored"),
                        ResResolver.getString("aihelp_permission_settings"), Snackbar.LENGTH_SHORT, new View.OnClickListener() {
                            @Override
                            public void onClick(View v) {
                                callback.onPermissionIgnored();
                            }
                        });
                break;
            case NONE:
                startActivityForResult(AttachmentDataProvider.getIntentForMedia(false), AIHelpWebChromeClient.REQUEST_CODE);
                break;
            default:
                if (mClient != null) mClient.cancelChooseFileDialog();
                break;
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        AIHelpPermissions.getInstance().onRequestPermissionsResult(permissions, grantResults);
    }

}
