package net.aihelp.ui.cs;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.os.Build;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.event.PrepareMessageTimeStampEvent;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.data.model.faq.FaqContentEntity;
import net.aihelp.ui.webkit.AIHelpWebChromeClient;
import net.aihelp.ui.webkit.AIHelpWebProgress;
import net.aihelp.ui.webkit.AIHelpWebView;
import net.aihelp.ui.webkit.AIHelpWebViewClient;
import net.aihelp.ui.widget.AIHelpEvaluateView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.TLog;

import org.json.JSONObject;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;


public class ElvaFaqBottomSheetEvent implements View.OnClickListener {

    private AlertDialog faqAlertDialog;

    private RelativeLayout rootLayout;
    private AIHelpWebView mWebView;
    private OnBotFaqInteractionCallback mListener;

    @SuppressLint("ClickableViewAccessibility")
    public ElvaFaqBottomSheetEvent(Fragment fragment, @NonNull ElvaBotMsg botMsg) {

        if (fragment == null || fragment.getContext() == null) return;
        Context context = fragment.getContext();

        faqAlertDialog = new AlertDialog.Builder(fragment.getContext())
                .setContentView(ResResolver.getLayoutId("aihelp_dia_elva_faq"))
                .setGravity(Gravity.BOTTOM)
                .fromBottom(true)
                .setCancelableOntheOutside(true)
                .setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialog) {
                        EventBus.getDefault().unregister(ElvaFaqBottomSheetEvent.this);
                        if (mListener != null) {
                            mListener.onDialogDismissed();
                        }
                    }
                })
                .setWidthAndHeight(ViewGroup.LayoutParams.MATCH_PARENT, 500)
                .setHeightByDevice()
                .create();

        rootLayout = faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_rl_root"));
        rootLayout.setBackgroundColor(Styles.getColor(CustomConfig.CommonSetting.upperBackgroundColor));

        final ImageView ivBack = faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_iv_back"));
        ivBack.setOnClickListener(this);
        Styles.reRenderImageView(ivBack, "aihelp_svg_ic_back");

        final ImageView ivClose = faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_iv_close"));
        ivClose.setOnClickListener(this);
        Styles.reRenderImageView(ivClose, "aihelp_svg_ic_close_dialog");

        mWebView = faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_web_view"));

        AIHelpWebProgress progressBar = faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_progress_bar"));
        AIHelpWebViewClient webViewClient = new AIHelpWebViewClient(fragment.getContext(), progressBar);
        webViewClient.setUrlLoadingListener(new AIHelpWebViewClient.ShouldOverrideUrlLoadingListener() {
            @Override
            public void handleUrlClickAndCancelCurrentLoad(boolean result) {
//                if (result) {
                    ivBack.setVisibility(View.VISIBLE);
//                }
            }
        });

        mWebView.setWebViewClient(webViewClient);

        AIHelpWebChromeClient chromeClient = new AIHelpWebChromeClient(fragment, progressBar);
        mWebView.setWebChromeClient(chromeClient);
        mWebView.setBackgroundColor(Color.TRANSPARENT);

        prepareEvaluateView(botMsg);

        EventBus.getDefault().register(this);

    }

    private void prepareEvaluateView(ElvaBotMsg botMsg) {
        AIHelpEvaluateView evaluateView = faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_evaluate_bot_faq"));
        evaluateView.setMainId(botMsg.getFaqMainId());
        evaluateView.setContentId(botMsg.getFaqContentId());
        if (CustomConfig.CommonSetting.isEvaluationForBotEnable) {
            switch (botMsg.getMsgStatus()) {
                case ConversationMsg.STATUS_FAQ_UNHELPFUL:
                    evaluateView.setEvaluateState(AIHelpEvaluateView.STATE_REQUESTING_FEEDBACK);
                    break;
                case ConversationMsg.STATUS_FAQ_HELPFUL:
                case ConversationMsg.STATUS_FAQ_UNHELPFUL_FEEDBACK_GIVEN:
                    evaluateView.setEvaluateState(AIHelpEvaluateView.STATE_INVISIBLE);
                    break;
                default:
                    evaluateView.setEvaluateState(AIHelpEvaluateView.STATE_NORMAL);
                    break;
            }
        } else {
            evaluateView.setEvaluateState(AIHelpEvaluateView.STATE_INVISIBLE);
        }
        evaluateView.setOnAIHelpEvaluateViewCallback(new AIHelpEvaluateView.OnAIHelpEvaluateViewCallback() {
            @Override
            public void onEvaluated(boolean isHelpful) {
                botMsg.setMsgStatus(isHelpful ? ConversationMsg.STATUS_FAQ_HELPFUL : ConversationMsg.STATUS_FAQ_UNHELPFUL);
                if (mListener != null) {
                    mListener.onEvaluatedFaq(isHelpful);
                }
            }

            @Override
            public void onFeedbackConfirmed() {
                botMsg.setMsgStatus(ConversationMsg.STATUS_FAQ_UNHELPFUL_FEEDBACK_GIVEN);
            }

            @Override
            public JSONObject requestDataForFeedback() {
                try {
                    JSONObject params = new JSONObject();
                    params.put("PlayerQuestion", botMsg.getUserInput());
                    params.put("TicketId", botMsg.getFaqTicketId());
                    params.put("PitchonQuestion", botMsg.getBotMsg());
                    // 需要保证时间戳与呼出的对应消息一致
                    params.put("CreateTime", botMsg.getTimeStamp());
                    return params;
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return super.requestDataForFeedback();
            }
        });
    }

    private void onBackPressed(View view) {
        if (mWebView.canGoBack()) {
            mWebView.goBack();
            if (!mWebView.canGoBack()) view.setVisibility(View.GONE);
        }
    }

    public void show(FaqContentEntity faq) {
        if (faqAlertDialog != null) faqAlertDialog.show();
        mWebView.loadDataWithBaseURL(null, faq.getFaqContent(), "text/html", "utf-8", null);
    }

    public void show(String url) {
        mWebView.loadUrl(url);
        if (faqAlertDialog != null) faqAlertDialog.show();
    }

    public void setOnBotFaqInteractionCallback(OnBotFaqInteractionCallback listener) {
        mListener = listener;
    }

    @Override
    public void onClick(View v) {
        if (faqAlertDialog == null) return;

        if (v.getId() == ResResolver.getViewId("aihelp_iv_close")) {
            faqAlertDialog.dismiss();
        }

        if (v.getId() == ResResolver.getViewId("aihelp_iv_back")) {
            onBackPressed(v);
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onEventComing(OrientationChangeEvent event) {
        if (faqAlertDialog != null && faqAlertDialog.isShowing()) {
            faqAlertDialog.dismiss();
        }
    }

    public static abstract class OnBotFaqInteractionCallback {
        public void onEvaluatedFaq(boolean isHelpful) {
        }

        public void onDialogDismissed() {
        }
    }

}
