package net.aihelp.ui.adapter.task.detail;

import android.content.Context;

import net.aihelp.core.ui.adapter.MultiItemTypeAdapter;
import net.aihelp.data.model.task.ReplyMessage;

public class TaskReplyListAdapter extends MultiItemTypeAdapter<ReplyMessage> {

    private final ReplyImageAdapter replyImageAdapter;
    private final ReplyVideoAdapter replyVideoAdapter;

    public TaskReplyListAdapter(Context context) {
        super(context);

        addItemViewDelegate(new ReplyTextAdapter(context));

        replyImageAdapter = new ReplyImageAdapter(context);
        addItemViewDelegate(replyImageAdapter);

        replyVideoAdapter = new ReplyVideoAdapter(context);
        addItemViewDelegate(replyVideoAdapter);

    }

    public void setOnReplyEventListener(OnReplyEventListener eventListener) {
        if (replyImageAdapter != null) {
            replyImageAdapter.setOnReplyEventListener(eventListener);
        }
        if (replyVideoAdapter != null) {
            replyVideoAdapter.setOnReplyEventListener(eventListener);
        }
    }

    public interface OnReplyEventListener {
        void onRetrySendingMessage(int position, ReplyMessage message);
    }

}
