package net.aihelp.ui.adapter.task.detail;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ItemViewDelegate;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.core.util.viewer.ImageViewer;
import net.aihelp.data.model.task.ReplyMessage;
import net.aihelp.ui.widget.AIHelpLoadingImageView;
import net.aihelp.utils.DateFormatUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.TLog;
import net.aihelp.utils.UploadFileHelper;

import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;


public class ReplyVideoAdapter extends BaseReplyAdapter {

    private final ExecutorService mExecutorService;

    public ReplyVideoAdapter(Context context) {
        super(context);
        mExecutorService = Executors.newCachedThreadPool();
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_task_reply_video");
    }

    @Override
    public boolean isForViewType(ReplyMessage item, int position) {
        return item.getMsgType() == ReplyMessage.MSG_TYPE_VIDEO;
    }

    @Override
    public void convert(ViewHolder holder, ReplyMessage replyMessage, int position) {
        super.convert(holder, replyMessage, position);

        if (replyMessage.getMsgStatus() == ReplyMessage.STATUS_SENDING) {
            AIHelpLoadingImageView imageView = holder.getView(ResResolver.getViewId("aihelp_iv_holder"));
            imageView.resetStatus();
            return;
        }

        if (replyMessage.getVideoThumbnail() != null) {
            loadUpImageView(holder, replyMessage);
        } else {
            if (mExecutorService != null) mExecutorService.execute(new Runnable() {
                @Override
                public void run() {
                    replyMessage.prepareVideoThumbnail();

                    // java.lang.IllegalArgumentException: You cannot start a load for a destroyed activity
                    if (mContext instanceof Activity && ((Activity) mContext).isFinishing()) {
                        TLog.e("You cannot start a load for a destroyed activity, interrupt current invoke.");
                        return;
                    }

                    ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            loadUpImageView(holder, replyMessage);
                        }
                    });
                }
            });
        }
    }

}
