package net.aihelp.ui.adapter.task.detail;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.UnderlineSpan;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.common.IntentValues;
import net.aihelp.core.ui.adapter.ItemViewDelegate;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.viewer.ImageViewer;
import net.aihelp.data.event.PageHoppingEvent;
import net.aihelp.data.model.task.ReplyMessage;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DateFormatUtil;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.RegexDefinition;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.RichTextSlicer;
import net.aihelp.utils.Styles;
import net.aihelp.utils.TLog;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class ReplyTextAdapter extends BaseReplyAdapter {

    public ReplyTextAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_task_reply_container");
    }

    @Override
    public boolean isForViewType(ReplyMessage item, int position) {
        return item.getMsgType() == ReplyMessage.MSG_TYPE_TEXT;
    }

    @Override
    public void convert(ViewHolder holder, ReplyMessage replyMessage, int position) {
        super.convert(holder, replyMessage, position);
        LinearLayout llContent = holder.getView(ResResolver.getViewId("aihelp_ll_content"));
        llContent.removeAllViews();
        llContent.addView(RichTextSlicer.getRichTextView(mContext, replyMessage.getContent()));
    }

}
