package net.aihelp.ui.adapter.task.detail;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ItemViewDelegate;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.util.viewer.ImageViewer;
import net.aihelp.data.model.task.ReplyMessage;
import net.aihelp.ui.widget.AIHelpLoadingImageView;
import net.aihelp.utils.DateFormatUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.UploadFileHelper;

import java.io.File;
import java.util.List;

public class BaseReplyAdapter implements ItemViewDelegate<ReplyMessage> {

    protected Context mContext;
    protected TaskReplyListAdapter.OnReplyEventListener mEventListener;

    public BaseReplyAdapter(Context context) {
        this.mContext = context;
    }

    public void setOnReplyEventListener(TaskReplyListAdapter.OnReplyEventListener eventListener) {
        this.mEventListener = eventListener;
    }

    @Override
    public int getItemViewLayoutId() {
        return 0;
    }

    @Override
    public boolean isForViewType(ReplyMessage item, int position) {
        return false;
    }

    @Override
    public void convert(ViewHolder holder, ReplyMessage replyMessage, int position) {
        ImageView ivPortrait = holder.getView(ResResolver.getViewId("aihelp_iv_portrait"));
        boolean isAgent = replyMessage.getReplyType() == ReplyMessage.REPLY_TYPE_AGENT;
        Styles.loadIcon(
                ivPortrait,
                isAgent ? CustomConfig.CustomerService.csManualSupportPortrait : CustomConfig.CustomerService.csUserPortrait,
                true,
                isAgent ? "aihelp_svg_portrait_admin" : "aihelp_svg_portrait_user"
        );

        Styles.reRenderTextView(holder.getView(ResResolver.getViewId("aihelp_tv_time")),
                DateFormatUtil.dateFormat(replyMessage.getTimeStamp(), null),
                Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.3),
                true,
                12);

        View ivRetry = holder.getView(ResResolver.getViewId("aihelp_iv_msg_retry"));
        if (ivRetry != null) {
            ivRetry.setVisibility(replyMessage.getMsgStatus() == ReplyMessage.STATUS_FAILURE ? View.VISIBLE : View.GONE);
            ivRetry.setOnClickListener(getRetryHandler(position, replyMessage));
        }
    }

    @Override
    public void onDataSourceUpdated(List<ReplyMessage> data) {

    }

    protected View.OnClickListener getRetryHandler(int position, ReplyMessage replyMessage) {
        return new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mEventListener != null) {
                    replyMessage.setTimeStamp(System.currentTimeMillis());
                    replyMessage.setMsgStatus(ReplyMessage.STATUS_SENDING);
                    mEventListener.onRetrySendingMessage(position, replyMessage);
                    UploadFileHelper.INSTANCE.setOnUploadFileListener(new UploadFileHelper.OnUploadFileListener() {
                        @Override
                        public void onFileUploaded(String fileUrl) {
                            boolean isUrlValid = !TextUtils.isEmpty(fileUrl);
                            replyMessage.setContent(isUrlValid ? fileUrl : replyMessage.getContent());
                            replyMessage.setMsgStatus(isUrlValid ? ReplyMessage.STATUS_NORMAL : ReplyMessage.STATUS_FAILURE);
                            mEventListener.onRetrySendingMessage(position, replyMessage);
                        }
                    }).performUpload(new File(replyMessage.getContent()));
                }
            }
        };
    }

    protected void loadUpImageView(ViewHolder holder, final ReplyMessage replyMessage) {
        final AIHelpLoadingImageView imageView = holder.getView(ResResolver.getViewId("aihelp_iv_holder"));
        imageView.loadIntoImageView(mContext, replyMessage);
        imageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (imageView.isLoading()) return;
                ImageViewer imageViewer = ImageViewer.getDefault(mContext);
                if (replyMessage.getMsgType() == ReplyMessage.MSG_TYPE_IMAGE) {
                    imageViewer.updateImageResource(replyMessage.getContent());
                } else {
                    imageViewer.updateVideoResource(replyMessage.getVideoThumbnail(), replyMessage.getContent());
                }
                imageViewer.show();
            }
        });
    }

}
