package net.aihelp.ui.adapter.faq;

import android.content.Context;
import android.graphics.Color;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.CommonAdapter;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.ui.wrapper.FaqSelectedListenerWrapper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class FaqListAdapter extends CommonAdapter<FaqListEntity> {

    public FaqListAdapter(Context context) {
        super(context);
    }

    @Override
    protected int itemLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_faq_linear_list");
    }

    @Override
    protected void convert(ViewHolder holder, final FaqListEntity faq, int position) {

        switch (faq.getDisplayType()) {
            case FaqListEntity.FAQ_DISPLAY_SECTION:
                convertRootListView(holder, faq);
                break;
            case FaqListEntity.FAQ_DISPLAY_SUB_SECTION:
            case FaqListEntity.FAQ_DISPLAY_QUESTION_LIST:
                convertSubListView(holder, faq);
                break;
            case FaqListEntity.FAQ_DISPLAY_SEARCH:
                convertSearchMatchingFaqTitles(holder, faq);
                break;
        }

        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mListener != null) {
                    switch (faq.getDisplayType()) {
                        case FaqListEntity.FAQ_DISPLAY_SECTION:
                        case FaqListEntity.FAQ_DISPLAY_SUB_SECTION:
                            mListener.onIntentToSubSectionOrQuestionList(faq.getId(), faq.getTitle());
                            break;
                        case FaqListEntity.FAQ_DISPLAY_QUESTION_LIST:
                        case FaqListEntity.FAQ_DISPLAY_SEARCH:
                            mListener.onIntentToQuestionContent(faq.getId(), faq.getQuery());
                            break;
                    }
                }
            }
        });

    }

    private void convertRootListView(ViewHolder holder, final FaqListEntity faq) {
        TextView tvTitle = holder.getView(ResResolver.getViewId("aihelp_tv_title"));
        Styles.reRenderTextView(tvTitle, faq.getTitle());
    }

    private void convertSubListView(ViewHolder holder, final FaqListEntity faq) {
        holder.setVisible(ResResolver.getViewId("aihelp_iv_title"), false);
        TextView tvTitle = holder.getView(ResResolver.getViewId("aihelp_tv_title"));
        Styles.reRenderTextView(tvTitle, faq.getTitle());
    }

    private void convertSearchMatchingFaqTitles(ViewHolder holder, final FaqListEntity faq) {
        try {
            holder.setVisible(ResResolver.getViewId("aihelp_iv_title"), false);
            TextView tvTitle = holder.getView(ResResolver.getViewId("aihelp_tv_title"));
            tvTitle.setTextColor(Color.parseColor(CustomConfig.CommonSetting.textColor));
            tvTitle.setTextSize(15);

            String query = faq.getQuery();
            String sectionName = faq.getTitle();
            if (!TextUtils.isEmpty(query)) {
                String matchedWords = query.toLowerCase();
                String title = sectionName.toLowerCase();
                int highlightColor = Color.parseColor(CustomConfig.CommonSetting.highlightedColor);
                Spannable spannedTitle = new SpannableString(sectionName);
                for (int index = TextUtils.indexOf(title, matchedWords, 0); index >= 0; index = TextUtils.indexOf(title, matchedWords, index + matchedWords.length())) {
                    spannedTitle.setSpan(new ForegroundColorSpan(highlightColor), index, Math.min(index + matchedWords.length(), title.length()), 33);
                }
                tvTitle.setText(spannedTitle);
            } else {
                tvTitle.setText(sectionName);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private FaqSelectedListenerWrapper mListener;

    public void setOnFaqSelectedListener(FaqSelectedListenerWrapper mListener) {
        this.mListener = mListener;
    }


}
