package net.aihelp.ui.adapter.cs.admin;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.util.viewer.ImageViewer;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.widget.AIHelpLoadingImageView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AdminImageAdapter extends BaseMsgAdapter {

    public AdminImageAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_admin_image");
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == ConversationMsg.TYPE_ADMIN_IMAGE;
    }

    @Override
    public void convert(ViewHolder holder, final ConversationMsg conversationMsg, final int position) {

        Styles.loadIcon(holder.getView(getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csManualSupportPortrait,
                CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_admin");

        TextView tvNickname = holder.getView(getViewId("aihelp_tv_nickname"));
        if (CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty(conversationMsg.getNickname())) {
            tvNickname.setVisibility(View.VISIBLE);
            tvNickname.setText(conversationMsg.getNickname());
            tvNickname.setTextSize(13);
            tvNickname.setTextColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8));
        } else {
            tvNickname.setVisibility(View.GONE);
        }

        final AIHelpLoadingImageView imageView = holder.getView(getViewId("aihelp_iv_holder"));
        imageView.loadIntoImageView(mContext, conversationMsg);

        imageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (imageView.isLoading()) return;
                ImageViewer imageViewer = ImageViewer.getDefault(mContext);
                imageViewer.updateImageResource(conversationMsg.getMsgContent());
                imageViewer.show();
            }
        });

    }

}
