package net.aihelp.data.model.task;

import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.text.TextUtils;

import net.aihelp.core.ui.image.Picasso;
import net.aihelp.ui.helper.BitmapHelper;
import net.aihelp.utils.MediaUtils;
import net.aihelp.utils.RegexDefinition;
import net.aihelp.utils.TLog;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.regex.Pattern;

public class ReplyMessage {

    public static final int REPLY_TYPE_AGENT = 2;
    public static final int REPLY_TYPE_USER = 3;

    public static final int MSG_TYPE_TEXT = 1;
    public static final int MSG_TYPE_IMAGE = 2;
    public static final int MSG_TYPE_VIDEO = 3;

    public static final int STATUS_NORMAL = 1;
    public static final int STATUS_SENDING = 2;
    public static final int STATUS_FAILURE = 3;

    private int replyType;
    private int msgType;
    private long timeStamp;
    private int msgStatus = STATUS_NORMAL;
    private String content = "";
    private String videoThumbnail;
    private int[] imageSize;

    public int getReplyType() {
        return replyType;
    }

    public void setReplyType(int replyType) {
        this.replyType = replyType;
    }

    public int getMsgType() {
        return msgType;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public long getTimeStamp() {
        return timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        int msgType = MSG_TYPE_TEXT;
        if (!TextUtils.isEmpty(content)) {
            if (Pattern.compile(RegexDefinition.REGEX_IMAGE).matcher(content).matches()) {
                msgType = MSG_TYPE_IMAGE;
            } else if (Pattern.compile(RegexDefinition.REGEX_VIDEO).matcher(content).matches()) {
                msgType = MSG_TYPE_VIDEO;
            }
        }
        setMsgType(msgType);
        this.content = content;
    }

    public int getMsgStatus() {
        return msgStatus;
    }

    public void setMsgStatus(int msgStatus) {
        this.msgStatus = msgStatus;
    }

    public String getVideoThumbnail() {
        return videoThumbnail;
    }

    public void setVideoThumbnail(String videoThumbnail) {
        this.videoThumbnail = videoThumbnail;
        setImageSize(BitmapHelper.computeSize(videoThumbnail));
    }

    public int[] getImageSize() {
        return imageSize;
    }

    public void setImageSize(int[] imageSize) {
        this.imageSize = imageSize;
    }

    public void prepareVideoThumbnail() {

        try {
            String videoPath = getContent();
            boolean isLocalFile = Pattern.compile("^(/.+)+\\.(mp4|MP4)$").matcher(videoPath).matches();
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            if (isLocalFile) {
                mmr.setDataSource(videoPath);
            } else {
                mmr.setDataSource(videoPath, new HashMap<String, String>());
            }

            Bitmap bitmap = mmr.getFrameAtTime();
            File f = MediaUtils.getOutputMediaFile(MediaUtils.MEDIA_TYPE_IMAGE);
            if (f != null) {
                try {
                    FileOutputStream out = new FileOutputStream(f);
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 90, out);
                    out.flush();
                    out.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
                setVideoThumbnail(f.getAbsolutePath());
            }
            mmr.release();
        } catch (Exception e) {
            e.printStackTrace();
            TLog.e("prepareVideoThumbnail failed, " + e.toString());
        }
    }

    public int getReplyFormat() {
        if (msgType == MSG_TYPE_TEXT) {
            return 1;
        }
        return 2;
    }

}
