package net.aihelp.data.model.cs.storyline;


import android.os.Build;
import android.text.TextUtils;

import net.aihelp.common.API;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.utils.DeviceInfoUtil;
import net.aihelp.utils.DomainSupportHelper;

import org.json.JSONObject;

public class BotUrl {

    private String urlTitle;
    private String urlAddress;

    public BotUrl(String urlTitle, String urlAddress) {
        this.urlTitle = urlTitle;
        this.urlAddress = DomainSupportHelper.getAdjustedUrl(urlAddress);
        getFormattedUrl(this.urlAddress);
    }

    public String getUrlTitle() {
        return urlTitle;
    }

    public void setUrlTitle(String urlTitle) {
        this.urlTitle = urlTitle;
    }

    public String getUrlAddress() {
        return urlAddress;
    }

    public void setUrlAddress(String urlAddress) {
        this.urlAddress = urlAddress;
    }

    private void getFormattedUrl(String url) {
        if (!TextUtils.isEmpty(url) && url.contains("type=login")) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("modelInfo", String.format("%s %s", Build.MANUFACTURER, Build.MODEL).replace(" ", "-"));
                jsonObject.put("userId", UserProfile.USER_ID);
                jsonObject.put("serverId", UserProfile.SERVER_ID);
                jsonObject.put("country", DeviceInfoUtil.getInstance().getSimCountryIso());
                AIHelpRequest.getInstance().requestPostByJson(API.GET_USER_TOKEN, jsonObject, new ReqCallback<String>() {
                    @Override
                    public void onReqSuccess(String result) {
                        try {
                            String userToken = JsonHelper.optString(new JSONObject(result), "userToken");
                            BotUrl.this.urlAddress = String.format("%s&clientparam=%s", url, userToken);
                        } catch (Exception e) {
                            // ignored
                        }
                    }
                });
            } catch (Exception e) {
                // ignored
            }
        }
    }


}
