package net.aihelp.data.model.cs;


public class ChatHistoryEntity implements Comparable<ChatHistoryEntity> {

    public static final int TYPE_ADMIN = 1;
    public static final int TYPE_USER = 2;
    public static final int TYPE_TIMESTAMP = 3;

    private long timeStamp;
    private int msgType;
    private String supportName;
    private String supportNickname;

    public String getSupportNickname() {
        return supportNickname;
    }

    public void setSupportNickname(String supportNickname) {
        this.supportNickname = supportNickname;
    }

    public String getSupportName() {
        return supportName;
    }

    public void setSupportName(String supportName) {
        this.supportName = supportName;
    }

    public long getTimeStamp() {
        return timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public int getMsgType() {
        return msgType;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    @Override
    public int compareTo(ChatHistoryEntity historyEntity) {
        return timeStamp < historyEntity.getTimeStamp() ? -1 : 1;
    }
}
