package net.aihelp.data.logic;

import android.content.Context;

import net.aihelp.common.API;
import net.aihelp.core.mvp.AbsPresenter;
import net.aihelp.core.mvp.IRepository;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.model.task.TaskEntity;
import net.aihelp.data.model.task.TaskListEntity;
import net.aihelp.ui.task.TaskListFragment;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

public class TaskListPresenter extends AbsPresenter<TaskListFragment, IRepository> {

    public TaskListPresenter(Context context) {
        super(context);
    }

    public void requestTaskList(int currentPage) {
        if (currentPage == 1) {
            mView.showLoading();
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("pageIndex", currentPage);
            jsonObject.put("pageSize", 20);
        } catch (JSONException ignored) {
        }
        get(API.TICKET_LIST, jsonObject, new ReqCallback<String>() {
            @Override
            public void onReqSuccess(String result) {
                if (mView != null) {
                    TaskListEntity ticketList = JsonHelper.toJavaObject(result, TaskListEntity.class);
                    if (ticketList != null) {
                        List<TaskEntity> list = ticketList.getItems();
                        if (currentPage == 1) mView.restoreViewState();
                        boolean noMoreData = currentPage == ticketList.getTotalPages();
                        mView.refreshTicketList(noMoreData, list);
                    }
                }
            }

            @Override
            public void onFailure(String url, int errorCode, String errorMsg) {
                if (currentPage == 1 && mView != null) {
                    mView.restoreViewState();
                    mView.showEmpty();
                }
            }
        });
    }
}