package net.aihelp.data.logic;

import android.content.Context;
import android.text.TextUtils;

import net.aihelp.common.API;
import net.aihelp.core.mvp.AbsPresenter;
import net.aihelp.core.mvp.IRepository;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.model.task.ReplyMessage;
import net.aihelp.data.model.task.TaskDetailEntity;
import net.aihelp.ui.task.detail.TaskDetailFragment;

import org.json.JSONArray;
import org.json.JSONObject;

import java.sql.Array;
import java.util.ArrayList;
import java.util.List;

public class TaskDetailPresenter extends AbsPresenter<TaskDetailFragment, IRepository> {

    public TaskDetailPresenter(Context context) {
        super(context);
    }

    public void requestTaskContent(String taskCode) {
        JSONObject params = JsonHelper.getJsonObject();
        JsonHelper.put(params, "taskCode", taskCode);
        AIHelpRequest.getInstance().requestGetByAsync(API.TICKET_CONTENT, params, new ReqCallback<TaskDetailEntity>() {
            @Override
            public void onReqSuccess(TaskDetailEntity entity) {
                if (mView != null) {
                    mView.refreshTaskContent(entity, getReplyMessageList(entity.getMessageList()));
                }
            }
        });
    }

    public void onUserReply(String taskCode, String reply, int inputFormat) {
        JSONObject params = JsonHelper.getJsonObject();
        JsonHelper.put(params, "taskCode", taskCode);
        JsonHelper.put(params, "input", reply);
        JsonHelper.put(params, "inputFormat", inputFormat);
        AIHelpRequest.getInstance().requestPostByJson(API.TICKET_MESSAGE, params, new ReqCallback<String>() {
            @Override
            public void onReqSuccess(String result) {

            }
        });
    }

    private List<ReplyMessage> getReplyMessageList(String jsonString) {
        ArrayList<ReplyMessage> list = new ArrayList<>();
        JSONArray jsonArray = JsonHelper.getJsonArray(jsonString);
        for (int i = jsonArray.length() - 1; i >= 0; i--) {
            JSONObject jsonObject = JsonHelper.getJsonObject(jsonArray, i);
            String content = JsonHelper.opt(jsonObject, "content", "");
            long createTime = JsonHelper.opt(jsonObject, "createTime", 0L);
            int replyType = JsonHelper.opt(jsonObject, "replyType", 0);

            if (!TextUtils.isEmpty(content)) {
                ReplyMessage replyMessage = new ReplyMessage();
                replyMessage.setReplyType(replyType);
                replyMessage.setTimeStamp(createTime);
                replyMessage.setContent(content);
                list.add(replyMessage);
            }
        }
        return list;
    }

}