package net.aihelp.data.logic;

import android.content.Context;

import net.aihelp.core.mvp.AbsPresenter;
import net.aihelp.core.mvp.IRepository;

import net.aihelp.data.localize.data.OperateHelper;
import net.aihelp.data.model.op.OperateArticle;
import net.aihelp.ui.op.OperateContentFragment;


public class OperatePresenter extends AbsPresenter<OperateContentFragment, IRepository> {

    public OperatePresenter(Context context) {
        super(context);
    }

    public void goFetchOperateContent(final String articleId) {
        if (mView != null) {
            final OperateArticle article = OperateHelper.INSTANCE.getArticleById(articleId);
            if (article != null) {
                mView.refreshOperateContent(article);
            } else {
                mView.showEmpty();
            }
        }
    }

    public boolean haveUnreadArticles() {
        return OperateHelper.INSTANCE.haveUnreadArticles();
    }

    public boolean shouldShowEvaluateFooter(String faqMainId) {
        return OperateHelper.INSTANCE.shouldShowArticleFooter(faqMainId);
    }
}
