package net.aihelp.data.logic;

import android.content.Context;
import android.text.TextUtils;
import android.widget.Toast;

import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.SpKeys;
import net.aihelp.common.UserProfile;
import net.aihelp.core.mvp.IRepository;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.http.callback.UploadCallback;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.net.mqtt.callback.IMqttCallback;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.data.model.init.UploadEntity;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.ui.cs.ConversationFragment;
import net.aihelp.ui.helper.ConversationHelper;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.TLog;
import net.aihelp.utils.ToastUtil;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.File;
import java.util.List;


public class ConversationPresenter extends MqttPresenter<ConversationFragment, IRepository> {

    public ConversationPresenter(Context context) {
        super(context);
    }

    public void uploadImage(File file, final long timeStamp) {
        if (!validateNetwork() && mView != null) {
            mView.showError(ResResolver.getString("aihelp_network_no_connect"));
            mView.updateMsgStatus(false, timeStamp);
            return;
        }

        AIHelpRequest.getInstance().requestUpLoadFile(API.UPLOAD_IMAGE_URL, file, new UploadCallback<UploadEntity.ImageResult>() {
            @Override
            public void onReqSuccess(UploadEntity.ImageResult result) {
                if (result != null) {
                    chatWithSupport(timeStamp, result.getUrl());
                }
            }

        });
    }

    public void uploadVideo(File file, final long timeStamp) {
        if (!validateNetwork() && mView != null) {
            mView.showError(ResResolver.getString("aihelp_network_no_connect"));
            mView.updateMsgStatus(false, timeStamp);
            return;
        }
        AIHelpRequest.getInstance().requestUpLoadFile(API.UPLOAD_VIDEO_URL, file, new UploadCallback<UploadEntity.VideoResult>() {

            @Override
            public void onReqSuccess(UploadEntity.VideoResult result) {
                if (result != null) {
                    chatWithSupport(timeStamp, result.getData());
                }
            }

            // FIXME: Uploading video failure callback and layout changes

        });
    }

    public void prepareMqttConnection(IMqttCallback callback) {
        callback.showMqttLoading();

        if (isNetworkAvailable()) {
            callback.updateHostView(mView);
            AIHelpMqtt.getInstance().prepare(MqttConfig.TYPE_CONVERSATION, callback);
        } else {
            if (mView != null) mView.showError(ResResolver.getString("aihelp_network_no_connect"));
        }

        goFetchUnreadMessageCount();
    }

    public void chatWithSupport(long timeStamp, String userSay) {
        try {
            JSONObject chatParams = new JSONObject();
            chatParams.put("msg", userSay);
            chatParams.put("timeStamp", timeStamp);
            chatParams.put("chatTags", "");
            chatParams.put("imgFlag", "0");
            mqtt(API.TOPIC_CONVERSATION_SEND, chatParams);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void evaluateSupport(int rate, String inputSuggestion, JSONArray selectedItems) {
        try {
            JSONObject evaluateParams = new JSONObject();
            evaluateParams.put("star_index", rate);
            evaluateParams.put("else_msg", inputSuggestion);
            evaluateParams.put("choose_list", selectedItems);
            mqtt(API.TOPIC_CONVERSATION_EVALUATE, evaluateParams);
        } catch (Exception e) {
            e.printStackTrace();
        }
        // mSp.put(UserProfile.USER_ID, 0);
    }

    public void saveInputDraftIfNeeded(String inputContent) {
        if (!TextUtils.isEmpty(inputContent)) {
            mSp.put(SpKeys.INPUT_DRAFT, inputContent);
        }
    }

    public void getLastConversation(int currentPage) {
        if (!isNetworkAvailable()) {
            ToastUtil.INSTANCE.makeRawToast(mContext, ResResolver.getString("aihelp_network_no_connect"));
            if (mView != null) {
                mView.onLastConversationRetrieved(null);
            }
            return;
        }

        try {
            JSONObject hashMap = new JSONObject();
            hashMap.put("userId", UserProfile.USER_ID);
            hashMap.put("deviceId", DeviceUuidFactory.id(mContext));
            hashMap.put("index", String.valueOf(currentPage));
            get(API.GET_LAST_CONVERSATION, hashMap, new ReqCallback<String>() {
                @Override
                public void onReqSuccess(String result) {
                    if (mView != null) {
                        if (!TextUtils.isEmpty(result)) {
                            try {
                                final List<ConversationMsg> list = ConversationHelper.getRetrievedMsgList(new JSONObject(result));
                                mView.onLastConversationRetrieved(list);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }

                @Override
                public void onFailure(String url, int errorCode, String errorMsg) {
                    if (mView != null) {
                        mView.onLastConversationRetrieved(null);
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void goFetchUnreadMessageCount() {
        try {
            JSONObject params = new JSONObject();
            params.put("appid", Const.APP_ID);
            params.put("uid", UserProfile.USER_ID);
            AIHelpRequest.getInstance().requestGetByAsync(API.FETCH_NEW_MSG, params, new ReqCallback<String>() {
                @Override
                public void onReqSuccess(String result) {
                    try {
                        if (!TextUtils.isEmpty(result)) {
                            JSONObject jsonObject = new JSONObject(result);
                            Const.TOGGLE_FETCH_MESSAGE = jsonObject.optBoolean("isHaveChat");
                            int newCount = jsonObject.optInt("cs_message_count");
                            mSp.put(UserProfile.USER_ID, newCount);

                            // Give caller a unread message count of 0 to notify them user has read
                            // all messages after cached latest message count.
                            // changed at 2021/08/11 since v2.5.1
                            if (Const.TOGGLE_OPEN_UNREAD_MSG && Const.sMessageListener != null) {
                                Const.sMessageListener.onMessageCountArrived(0);
                            }
                        }
                    } catch (Exception e) {
                        TLog.e("Conversation fetch new msg failed, because " + e.toString());
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateCachedUnreadMessageCount(boolean withdrawMessage) {
        int cacheCount = mSp.getInt(UserProfile.USER_ID, 0);
        mSp.put(UserProfile.USER_ID, withdrawMessage ? --cacheCount : ++cacheCount);
    }

    public String getInputDraft() {
        return mSp.getString(SpKeys.INPUT_DRAFT, "");
    }

    public void clearInputDraft() {
        mSp.put(SpKeys.INPUT_DRAFT, "");
    }

}
