package net.aihelp.data.localize.util;

import android.text.TextUtils;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.config.AIHelpContext;
import net.aihelp.data.localize.LocalizeHelper;
import net.aihelp.utils.TLog;

import java.io.File;

public class LocalizeUtil {

    public static boolean isAIMLLocalized() {
        return LocalizeUtil.isAlreadyLocalized(LocalizeHelper.FLAG_STORY);
    }

    public static boolean isFallbackUrl(int mode, String url) {
        return (mode == LocalizeHelper.FLAG_FAQ_SECTION || mode == LocalizeHelper.FLAG_OP) && url.endsWith(String.format("%s-from-api.json", Const.CORRECT_LANGUAGE));
    }

    public static String getFileLocation(int mode, String fileName) {
        String dirPath = "";
        File filesDir = AIHelpContext.getInstance().getContext().getFilesDir();
        if (filesDir != null) {
            dirPath = filesDir.getAbsolutePath() + "/AIHelp" + LocalizeUtil.getFolderName(mode) + Const.CORRECT_LANGUAGE;
            File dirFile = new File(dirPath);
            if (!dirFile.exists()) {
                if (dirFile.mkdirs()) {
                    return dirFile.getAbsolutePath() + File.separator + fileName;
                }
            }
        }
        return dirPath + File.separator + fileName;
    }

    public static String getFileLocation(int mode) {
        return getFileLocation(mode, LocalizeUtil.getFileName(mode));
    }

    public static String getUrl(int mode) {
        switch (mode) {
            case LocalizeHelper.FLAG_LOCALE:
                return API.LOCALE_FILE_URL;
            case LocalizeHelper.FLAG_STYLE_SHEET:
                return API.CONFIG_STYLE_SHEET_URL;
            case LocalizeHelper.FLAG_BUSINESS_LOGIC:
                return API.CONFIG_BUSINESS_LOGIC_URL;
            case LocalizeHelper.FLAG_FEEDBACK_OPINION:
                return API.CONFIG_OPINION_URL;
            case LocalizeHelper.FLAG_FAQ_HOT_TOPIC:
                return API.CONFIG_FAQ_HOT_TOPIC_URL;
            case LocalizeHelper.FLAG_PROCESS:
                return API.CONFIG_PROCESS_URL;
            case LocalizeHelper.FLAG_TEXT:
                return API.CONFIG_TEXT_URL;
            default:
                return API.CDN_URL + LocalizeUtil.getFolderName(mode) + Const.APP_ID + File.separator + LocalizeUtil.getFileName(mode);
        }
    }

    // 判断当前本地有没有初始化返回的那几个文件
    public static boolean isAlreadyLocalized(int mode) {
        try {
            String path = getFileLocation(mode);
            File file = new File(path);
            if (file.exists()) {
                return true;
            } else {
                File parentFile = file.getParentFile();
                if (parentFile != null) {
                    File[] files = parentFile.listFiles();
                    if (files != null && files.length > 0) {
                        for (File oldFile : files) {
                            if (oldFile.delete()) {
                                return false;
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            TLog.e("LocalizeHelper check localize status failed.");
        }
        return false;
    }

    public static String getFolderName(int mode) {
        String middle = "";
        switch (mode) {
            case LocalizeHelper.FLAG_STORY:
                middle = "/AIML/";
                break;
            case LocalizeHelper.FLAG_FAQ_SECTION:
                middle = "/FAQ/";
                break;
            case LocalizeHelper.FLAG_OP:
                middle = "/OPerMode/";
                break;
            case LocalizeHelper.FLAG_LOCALE:
                middle = "/locale/";
                break;
            case LocalizeHelper.FLAG_STYLE_SHEET:
                middle = "/stylesheet/";
                break;
            case LocalizeHelper.FLAG_BUSINESS_LOGIC:
                middle = "/toggle/";
                break;
            case LocalizeHelper.FLAG_FEEDBACK_OPINION:
                middle = "/opinion/";
                break;
            case LocalizeHelper.FLAG_FAQ_HOT_TOPIC:
                middle = "/hotTopic/";
                break;
            case LocalizeHelper.FLAG_PROCESS:
                middle = "/process/";
                break;
            case LocalizeHelper.FLAG_TEXT:
                middle = "/text/";
                break;
        }
        return middle;
    }

    public static String getFileName(int mode) {
        String fileName = "";
        switch (mode) {
            case LocalizeHelper.FLAG_STORY:
                fileName = Const.STORY_FILE;
                break;
            case LocalizeHelper.FLAG_FAQ_SECTION:
                fileName = getLocalizeFileName(Const.FAQ_FILE);
                break;
            case LocalizeHelper.FLAG_OP:
                fileName = getLocalizeFileName(Const.OP_FILE);
                break;
            case LocalizeHelper.FLAG_LOCALE:
                fileName = getLocalizeFileName(API.LOCALE_FILE_URL);
                break;
            case LocalizeHelper.FLAG_STYLE_SHEET:
                fileName = getLocalizeFileName(API.CONFIG_STYLE_SHEET_URL);
                break;
            case LocalizeHelper.FLAG_BUSINESS_LOGIC:
                fileName = getLocalizeFileName(API.CONFIG_BUSINESS_LOGIC_URL);
                break;
            case LocalizeHelper.FLAG_FEEDBACK_OPINION:
                fileName = getLocalizeFileName(API.CONFIG_OPINION_URL);
                break;
            case LocalizeHelper.FLAG_FAQ_HOT_TOPIC:
                fileName = getLocalizeFileName(API.CONFIG_FAQ_HOT_TOPIC_URL);
                break;
            case LocalizeHelper.FLAG_PROCESS:
                fileName = getLocalizeFileName(API.CONFIG_PROCESS_URL);
                break;
            case LocalizeHelper.FLAG_TEXT:
                fileName = getLocalizeFileName(API.CONFIG_TEXT_URL);
                break;
        }
        return fileName;
    }

    private static String getLocalizeFileName(String url) {
        if (!TextUtils.isEmpty(url)) {
            String[] split = url.split("/");
            if (split.length > 0) {
                return split[split.length - 1];
            }
        }
        return String.format("%s-from-api.json", Const.CORRECT_LANGUAGE);
    }

}
