package net.aihelp.data.localize.config;

import android.text.TextUtils;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.LocalizeHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.model.config.StyleSheetEntity;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.FileUtil;

public enum StyleSheetHelper {

    INSTANCE;

    public void prepareDataSource() {
        try {
            // 从本地读取样式配置文件
            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(LocalizeHelper.FLAG_STYLE_SHEET));
            if (!TextUtils.isEmpty(content)) {
                StyleSheetEntity styleEntity = JsonHelper.toJavaObject(content, StyleSheetEntity.class);
                if (styleEntity != null) {
                    prepareCommonConfig(styleEntity.getGeneral());
                    prepareHelpCenterConfig(styleEntity.getHelp());
                    prepareCustomerServiceConfig(styleEntity.getOnLine());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prepareCustomerServiceConfig(StyleSheetEntity.OnLineEntity entity) {
        CustomConfig.CustomerService.csNavigationBarTitleIcon = getCorrectedUrl(entity.getNavBar());
        CustomConfig.CustomerService.csBotSupportPortrait = getCorrectedUrl(entity.getRobotImgUrl());
        CustomConfig.CustomerService.csManualSupportPortrait = getCorrectedUrl(entity.getCustomerImgUrl());
        CustomConfig.CustomerService.csUserPortrait = getCorrectedUrl(entity.getUserImgUrl());
    }

    private void prepareHelpCenterConfig(StyleSheetEntity.HelpEntity entity) {
        CustomConfig.HelpCenter.faqNavigationBarTitleIcon = getCorrectedUrl(entity.getNavBar());
        CustomConfig.HelpCenter.faqNotificationIcon = getCorrectedUrl(entity.getNoticeBar());
        CustomConfig.HelpCenter.faqHotTopicTitleIcon = getCorrectedUrl(entity.getFaqList());
        CustomConfig.HelpCenter.faqSectionTitleIcon = getCorrectedUrl(entity.getFaqSectionList());
    }

    private void prepareCommonConfig(StyleSheetEntity.GeneralEntity entity) {

        if (entity.getNavBar() != null) {
            CustomConfig.CommonSetting.navigationBarBackground = entity.getNavBar().getColor();
            CustomConfig.CommonSetting.navigationBarAlpha = entity.getNavBar().getTransparency();
        }

        CustomConfig.CommonSetting.backgroundColorForAll = entity.getVertical();
        CustomConfig.CommonSetting.backgroundImageForPortrait = getCorrectedUrl(entity.getVerticalImgUrl());
        CustomConfig.CommonSetting.backgroundImageForLandscape = getCorrectedUrl(entity.getHorizontalImgUrl());

        if (entity.getFrontColor() != null) {
            CustomConfig.CommonSetting.upperBackgroundColor = entity.getFrontColor().getColor();
            CustomConfig.CommonSetting.upperBackgroundAlpha = entity.getFrontColor().getTransparency();
        }

        CustomConfig.CommonSetting.textColor = entity.getTextColor();
        CustomConfig.CommonSetting.highlightedColor = entity.getHighlightColor();
        CustomConfig.CommonSetting.interactElementTextColor = entity.getButtonColor();
    }

    private String getCorrectedUrl(String originUrl) {
        return DomainSupportHelper.getAdjustedUrl(originUrl);
    }

}
