package net.aihelp.core.util.permission;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.view.View;
import android.widget.TextView;

import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.utils.ResResolver;

public class RequestAlertHelper {

    private static final String AIHELP_PERMISSION_REQUEST_ALERT = "AIHELP_PERMISSION_REQUEST_ALERT";

    private static boolean checkMetaData(Context context) {
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(
                    context.getPackageName(), PackageManager.GET_META_DATA);
            if (appInfo.metaData != null) {
                for (String key : appInfo.metaData.keySet()) {
                    if (AIHELP_PERMISSION_REQUEST_ALERT.equals(key)) {
                        return "yes".equals(appInfo.metaData.get(key));
                    }
                }
            }
        } catch (Exception ignored) {
            // ignored
        }
        return false;
    }

    public static void request(Context context, PermissionHelper helper) {
        if (helper == null) return;
        if (context != null && checkMetaData(context)) {
            showRequestAlert(context, helper);
        } else {
            helper.requestPermission();
        }
    }

    public static void showRequestAlert(Context context, PermissionHelper helper) {
        // avoid showing multiple dialog during the for loop
        if (helper.avoidInvoking()) return;

        final AlertDialog requestPermissionDialog = new AlertDialog.Builder(context)
                .setContentView(ResResolver.getLayoutId("aihelp_dia_request_permission"))
                .setWidthByDevice()
                .create();

        final TextView tvTitle = requestPermissionDialog.getView(ResResolver.getViewId("aihelp_tv_title"));
        final TextView tvCancel = requestPermissionDialog.getView(ResResolver.getViewId("aihelp_tv_cancel"));
        final TextView tvConfirm = requestPermissionDialog.getView(ResResolver.getViewId("aihelp_tv_confirm"));

        tvTitle.setText(ResResolver.getString("aihelp_storage_permission"));
        tvCancel.setText(ResResolver.getString("aihelp_no"));
        tvConfirm.setText(ResResolver.getString("aihelp_yes"));

        requestPermissionDialog.setOnClickListener(ResResolver.getViewId("aihelp_tv_cancel"), new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                requestPermissionDialog.dismiss();
                helper.setInvokeId(-1);
                helper.invokePermissionCallback(Permission.Result.CANCELED);
            }
        });

        tvConfirm.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                requestPermissionDialog.dismiss();
                helper.requestPermission();
            }
        });
        requestPermissionDialog.show();
    }

}
