package net.aihelp.core.util.permission;

import android.app.Activity;
import android.content.Context;

import androidx.fragment.app.Fragment;


public class AIHelpPermissions {

    private Activity activity;
    private Fragment fragment;
    private Object handler;
    private int requestCode = 0;
    private String[] permissions;

    private PermissionHelper helper;

    private AIHelpPermissions() {

    }

    public AIHelpPermissions setActivity(Activity activity) {
        this.activity = activity;
        return this;
    }

    public AIHelpPermissions setFragment(Fragment fragment) {
        this.fragment = fragment;
        return this;
    }

    public AIHelpPermissions setPermissionHandler(Object handler) {
        this.handler = handler;
        return this;
    }

    public AIHelpPermissions setRequestPermission(String... permissions) {
        this.permissions = permissions;
        return this;
    }

    public AIHelpPermissions setRequestCode(int requestCode) {
        this.requestCode = requestCode;
        return this;
    }


    public void request(Context context) {
        helper = PermissionHelper.getInstance(activity, fragment, handler, permissions, requestCode);
        Permission.State[] states = helper.checkPermissionState();
        for (Permission.State state : states) {
            switch (state) {
                case AVAILABLE:
                    helper.invokePermissionCallback(Permission.Result.GRANTED);
                    break;
                case UNAVAILABLE:
                    helper.invokePermissionCallback(Permission.Result.NONE);
                    break;
                case RATIONAL:
                    helper.invokePermissionCallback(Permission.Result.RATIONAL);
                    break;
                case ASKABLE:
                    RequestAlertHelper.request(context, helper);
                    break;
            }
            // update the invoke id after the switch-case to avoid multi-invoke-calling
            // for the same requestCode in the for-loop
            helper.setInvokeId(requestCode);
        }
    }

    public void onRequestPermissionsResult(String[] permissions, int[] grantResults) {
        if (helper != null) {
            helper.onRequestPermissionsResult(permissions, grantResults);
        }
    }

    public void recycle() {
        activity = null;
        fragment = null;
        handler = null;
        if (helper != null) {
            helper.recycle();
            helper = null;
        }
    }

    private static final class AIHelpPermissionsHolder {
        static final AIHelpPermissions sInstance = new AIHelpPermissions();
    }

    public static AIHelpPermissions getInstance() {
        return AIHelpPermissionsHolder.sInstance;
    }

}