package net.aihelp.core.util.logger;

import android.content.Context;

import net.aihelp.config.AIHelpContext;
import net.aihelp.core.db.BaseSQLiteHelper;
import net.aihelp.core.db.DropAndCreateDatabaseHelper;
import net.aihelp.core.db.IDatabaseContract;
import net.aihelp.core.db.IMigrateContract;
import net.aihelp.core.util.logger.table.LoggerTable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LoggerDBHelper extends BaseSQLiteHelper {

    private static final int DB_VERSION = 1;
    private static final String CREATE_LOGGER_TABLE = "CREATE TABLE IF NOT EXISTS LOG_MESSAGES( TIMESTAMP TEXT, MESSAGE TEXT, LEVEL TEXT, STACKTRACE TEXT);";

    public LoggerDBHelper(Context context, IDatabaseContract contract) {
        super(context, contract);
    }

    public static LoggerDBHelper getInstance() {
        return LoggerDBHelper.LazyHolder.INSTANCE;
    }

    private static class LazyHolder {

        static final LoggerDBHelper INSTANCE = new LoggerDBHelper(
                AIHelpContext.getInstance().getContext().getApplicationContext(), new IDatabaseContract() {

            @Override
            public int getDatabaseVersion() {
                return DB_VERSION;
            }

            @Override
            public String getDatabaseName() {
                return "LoggerDatabase";
            }

            @Override
            public List<String> getCreateTableQueries() {
                return Collections.singletonList(CREATE_LOGGER_TABLE);
            }

            @Override
            public List<IMigrateContract> getMigratorsForUpgrade(int oldDbVersion) {
                List<IMigrateContract> contractList = new ArrayList<>();
                contractList.add(new DropAndCreateDatabaseHelper(this));
                return contractList;
            }

            @Override
            public List<String> getTableNames() {
                return Collections.singletonList(LoggerTable.TABLE_NAME);
            }

            @Override
            public String getTag() {
                return "AIHelp_DB_FAQ";
            }

        });
    }

}

