package net.aihelp.core.util.elva.text;

import java.util.List;

import net.aihelp.core.util.elva.aiml.Action;
import net.aihelp.core.util.elva.aiml.Alicekm;
import net.aihelp.core.util.elva.aiml.Pattern;
import net.aihelp.core.util.elva.aiml.Srai;
import net.aihelp.core.util.elva.aiml.Tag;
import net.aihelp.core.util.elva.aiml.Url;
import net.aihelp.core.util.elva.aiml.Url2;

public class Response extends Request {

    public Url url;
    public Url2 url2;
    public Alicekm alicekm;
    public List<Action> Actions;
    public List<Tag> tags;
    public Pattern pattern;

    public Response() {
        super();
    }

    public Response(String original) {
        super(original);
    }

    public Response(String original, Sentence... sentences) {
        super(original, sentences);
    }

    public void append(String output) {
        StringBuilder builder = new StringBuilder();
        String original = getOriginal();
        if (original != null) {
            builder.append(original);
            if (builder.charAt(builder.length() - 1) != ' ')
                builder.append(' ');
        }

        builder.append(output);
        setOriginal(builder.toString());
    }

    public boolean isPatternWildCard() {
        return pattern != null && pattern.toString().equals("*");
    }
}