package net.aihelp.core.util.elva.aiml;

import org.xml.sax.Attributes;

import net.aihelp.core.util.elva.Match;

public class Url2 extends TemplateElement {

    private String id;
    private String type;
    private String title;
    private String content;
    private String varlist;
    private String formurl;
  
    public Url2() {
    }

    public Url2(Attributes attributes) {
        id = attributes.getValue("id");
        type = attributes.getValue("type");
        title = attributes.getValue("title");
        content = attributes.getValue("content");
        varlist = attributes.getValue("varlist");
        formurl = attributes.getValue("formurl");
    }

    public Url2(String id, String type, String title, String content, String varlist, String formurl, Object... children) {
        super(children);
        this.id = id;
        this.type = type;
        this.title = title;
        this.content = content;
        this.varlist = varlist;
        this.formurl = formurl;
    }
  
    private boolean isEquals(Object comparing, Object compared) {
        return (comparing == null ? compared == null : comparing.equals(compared));
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)){
            return false;
        }
        Url2 compared = (Url2) obj;
        return (isEquals(id, compared.id) && isEquals(type, compared.type) && isEquals(title, compared.title) && isEquals(content, compared.content) && isEquals(varlist, compared.varlist) && isEquals(formurl, compared.formurl));
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getVarlist() {
        return varlist;
    }

    public void setVarlist(String varlist) {
        this.varlist = varlist;
    }

    public String getFormurl() {
        return formurl;
    }

    public void setFormurl(String formurl) {
        this.formurl = formurl;
    }

    public String process(Match match) {
        try {
            return String.format("<url2 id='%s' type='%s' title='%s' content='%s' varlist='%s' formurl='%s'></url2>", id, type, title.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;"), content.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;"), varlist, formurl);
        } catch (NullPointerException e) {
            return "";
        }
    }
}