package net.aihelp.core.util.elva.aiml;

import org.xml.sax.Attributes;

import net.aihelp.core.util.elva.Match;

public class Tag extends TemplateElement {

    private String id;
    private String name;

    public Tag() {
    }

    public Tag(Attributes attributes) {
        id = attributes.getValue("id");
        name = attributes.getValue("name");
    }

    public Tag(String name, String id, Object... children) {
        super(children);
        this.name = name;
        this.id = id;
    }

    private boolean isEquals(Object comparing, Object compared) {
        return (comparing == null ? compared == null : comparing.equals(compared));
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)){
            return false;
        }
        Tag compared = (Tag) obj;
        return (isEquals(name, compared.name) && isEquals(id, compared.id));
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String process(Match match) {
        try {
            return String.format("<tag id='%s' name='%s'></tag>", id.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;"),
                    name.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;"));
        } catch (NullPointerException e) {
            return "";
        }
    }
}