package net.aihelp.core.util.elva.aiml;

import org.xml.sax.Attributes;

import net.aihelp.core.util.elva.ElvaBot;
import net.aihelp.core.util.elva.Context;
import net.aihelp.core.util.elva.Match;
import net.aihelp.core.util.elva.script.Interpreter;

public class System extends TemplateElement {

    public System(Attributes attributes) {
    }

    public System(Object... children) {
        super(children);
    }
  
    public String process(Match match) {
        try {
            ElvaBot bot = match.getCallback();
            Context context = bot.getContext();
            Interpreter interpreter = (Interpreter) context.property("beanshell.interpreter");
            if (interpreter == null){
                return "";
            }
            String script = super.process(match);
            interpreter.variable("result", null);
            interpreter.variable("match", match);
            Object evaluated = interpreter.evaluate(script);
            Object result = interpreter.variable("result");
            if (result == null){
                result = evaluated;
            }
            interpreter.variable("match", null);
            return (result != null ? result.toString() : "");
        } catch (Exception e) {
            throw new RuntimeException("Evaluation error on <system> tag", e);
        }
    }
}