package net.aihelp.core.util.elva.aiml;

import org.xml.sax.Attributes;

import net.aihelp.core.util.elva.Match;

public class Get extends TemplateElement {

    private String name;
  
    public Get(Attributes attributes) {
        name = attributes.getValue(0);
    }

    public Get(String name) {
        this.name = name;
    }
  
    public boolean equals(Object compared) {
        if (compared == null || !(compared instanceof Get))
            return false;
        else
            return name.equals(((Get) compared).name);
    }

    public int hashCode() {
        return name.hashCode();
    }

    public String process(Match match) {
        try {
            String value = (String) match.getCallback().getContext().property("predicate." + name);
            return (value != null ? value : "");
        } catch (NullPointerException e) {
            return "";
        }
    }
}