package net.aihelp.core.util.elva.aiml;

import org.xml.sax.Attributes;

import net.aihelp.core.util.elva.Match;

public class Alicekm extends TemplateElement {

    private String id;
    private String type;

    public Alicekm() {
    }

    public Alicekm(Attributes attributes) {
        id = attributes.getValue("id");
        type = attributes.getValue("type");
    }

    public Alicekm(String id, String type, Object... children) {
        super(children);
        this.id = id;
        this.type = type;
    }

    private boolean isEquals(Object comparing, Object compared) {
        return (comparing == null ? compared == null : comparing.equals(compared));
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj))
            return false;
        Alicekm compared = (Alicekm) obj;
        return (isEquals(id, compared.id) && isEquals(type, compared.type));
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String process(Match match) {
        try {
            return String.format("<alicekm id='%s' type='%s'></alicekm>",
                    id.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;")
                            .replace("'", "&apos;"),
                    type.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;")
                            .replace("'", "&apos;"));
        } catch (NullPointerException e) {
            return "";
        }
    }
}