package net.aihelp.core.util.elva;

import java.beans.PropertyChangeEvent;

public class ContextRandomSeedChangeListener extends ContextPropertyChangeListener {

    public ContextRandomSeedChangeListener() {
        super("bot.randomSeed");
    }

    public void propertyChange(PropertyChangeEvent event) {
        Context context = (Context) event.getSource();
        Object oldSeed = event.getOldValue();
        Object newSeed = event.getNewValue();
        if (oldSeed == null ? newSeed == null : oldSeed.equals(newSeed)) {
            return;
        }
        long seed = Long.parseLong(newSeed.toString());
        context.random(seed);
    }
}