package net.aihelp.core.util.crash;

import android.app.Application;

import net.aihelp.BuildConfig;

import java.lang.reflect.Method;

public enum LeakChecker {

    INSTANCE;

    private Object refWatcher;

    public void install(Application app) {
        if (BuildConfig.DEBUG && app != null) {
            try {
                Class<?> leakCanary = Class.forName("com.squareup.leakcanary.LeakCanary");
                Method installMethod = leakCanary.getDeclaredMethod("install", Application.class);
                installMethod.setAccessible(true);
                refWatcher = installMethod.invoke(null, app);
            } catch (Exception e) {
                // ignored
            }
        }
    }

    public void watch(Object watchedReference) {
        if (BuildConfig.DEBUG && refWatcher != null && watchedReference != null) {
            stopWatching();
            try {
                Class<?> leakCanary = Class.forName("com.squareup.leakcanary.RefWatcher");
                Method watchMethod = leakCanary.getDeclaredMethod("watch", Object.class);
                watchMethod.setAccessible(true);
                watchMethod.invoke(refWatcher, watchedReference);
            } catch (Exception e) {
                // ignored
            }
        }
    }

    public void stopWatching() {
        if (BuildConfig.DEBUG && refWatcher != null) {
            try {
                Class<?> leakCanary = Class.forName("com.squareup.leakcanary.RefWatcher");
                Method clearWatchingMethod = leakCanary.getDeclaredMethod("clearWatchedReferences");
                clearWatchingMethod.setAccessible(true);
                clearWatchingMethod.invoke(refWatcher);
            } catch (Exception e) {
                // ignored
            }
        }
    }

}
