package net.aihelp.core.util.concurrent;

import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

public class DispatchQueue {
    private static final String TAG = "AIHelp_DispatchQueue";
    private LinkedBlockingQueue<Future> tasks = new LinkedBlockingQueue<>();
    private LinkedBlockingQueue<Thread> afterThreads = new LinkedBlockingQueue<>();
    private ExecutorService threadPoolExecutor;

    public DispatchQueue(boolean isConcurrent) {
        AIHelpThreadFactory threadFactory;
        if (isConcurrent) {
            threadFactory = new AIHelpThreadFactory("cmdpq-a");
            this.threadPoolExecutor = Executors.newCachedThreadPool(threadFactory);
        } else {
            threadFactory = new AIHelpThreadFactory("cmdpq-b");
            this.threadPoolExecutor = Executors.newSingleThreadExecutor(threadFactory);
        }

    }

    public void dispatchSync(Runnable runnable) {
        Future taskFuture = this.threadPoolExecutor.submit(runnable);

        try {
            taskFuture.get();
        } catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        } catch (ExecutionException e) {
            e.printStackTrace();
        }

    }

    private void trackTask(Future task) {
        this.tasks.add(task);
    }

    public void dispatchAsync(Runnable runnable) {
        Future task = this.threadPoolExecutor.submit(runnable);
        this.trackTask(task);
    }

    public void dispatchAfter(final Runnable runnable, final long interval) {
        Thread triggerThread = new Thread(new Runnable() {
            public void run() {
                try {
                    Thread.sleep(interval);
                    DispatchQueue.this.dispatchAsync(runnable);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }

            }
        }, "HS-cmdpq-trig");
        triggerThread.start();
        this.afterThreads.add(triggerThread);
    }

    public void join() {
        try {
            Iterator var1 = this.afterThreads.iterator();

            while(var1.hasNext()) {
                Thread t = (Thread)var1.next();
                t.join();
            }

            var1 = this.tasks.iterator();

            while(var1.hasNext()) {
                Future task = (Future)var1.next();
                task.get();
            }

            this.tasks.clear();
        } catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        } catch (ExecutionException e) {
            e.printStackTrace();
        }

    }
}

