package net.aihelp.core.util.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class AIHelpThreadFactory implements ThreadFactory {

    private final String poolName;

    private final AtomicInteger threadNumber = new AtomicInteger(1);

    public AIHelpThreadFactory(String poolName) {
        this.poolName = poolName;
    }

    public Thread newThread(Runnable r) {
        String threadName = "AIHelp-" + this.poolName + "-t-" + this.threadNumber.getAndIncrement();
        return new Thread(r, threadName);
    }

}
