package net.aihelp.core.net.mqtt.client;

import net.aihelp.core.net.mqtt.codec.MQTTFrame;

/**
 * A subclass of this can be configured on an MQTT connection to
 * get more insight into what it's doing.
 */
public class Tracer {

    /**
     * Override to log/capture debug level messages
     * @param message
     * @param args
     */
    public void debug(String message, Object...args) {
    }

    /**
     * Called when a MQTTFrame sent to the remote peer.
     * @param frame
     */
    public void onSend(MQTTFrame frame) {
    }

    /**
     * Called when a MQTTFrame is received from the remote peer.
     * @param frame
     */
    public void onReceive(MQTTFrame frame) {
    }

}
