package net.aihelp.core.net.mqtt.callback;

import net.aihelp.common.API;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.core.util.logger.AIHelpLogger;
import net.aihelp.ui.helper.LoginMqttHelper;

import net.aihelp.core.net.mqtt.client.Callback;

public class SubscribeCallback implements Callback<byte[]> {

    private boolean isFaqRequest;
    private IMqttCallback mqttCallback;
    private int connectionId;

    public SubscribeCallback(boolean isFaqRequest, IMqttCallback callback, int connectionId) {
        this.isFaqRequest = isFaqRequest;
        this.mqttCallback = callback;
        this.connectionId = connectionId;
    }

    @Override
    public void onSuccess(byte[] value) {
        if (this.connectionId == AIHelpMqtt.getInstance().getMqttConnectionId()) {
            if (!isFaqRequest && MqttConfig.getInstance().isConnected()) {
                AIHelpMqtt.getInstance().postToServer(API.TOPIC_LOGIN, LoginMqttHelper.getLoginParams());
            }
        }
    }

    @Override
    public void onFailure(final Throwable value) {
        if (this.connectionId == AIHelpMqtt.getInstance().getMqttConnectionId()) {
            AIHelpLogger.error("mqtt subscribe failure", value);
            ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (mqttCallback != null) {
                        mqttCallback.onMqttFailure("SubscribeCallback " + value.getMessage());
                    }
                }
            });
        }
    }

}
