package net.aihelp.core.net.http.interceptor;

import android.annotation.SuppressLint;
import android.text.TextUtils;

import net.aihelp.common.API;
import net.aihelp.common.SpKeys;
import net.aihelp.utils.FileUtil;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.TLog;

import org.json.JSONObject;

import java.io.IOException;
import java.util.Arrays;

import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;

public final class LogInterceptor implements Interceptor {

    @SuppressLint("DefaultLocale")
    @Override
    public Response intercept(Chain chain) throws IOException {

        Request request = chain.request();
        Response response = chain.proceed(request);

        try {
            String urlInfo = getLineTag(request.url());

            if (TextUtils.isEmpty(urlInfo) || isFileAddress(urlInfo)) {
                return response;
            }

            TLog.l(urlInfo, true);
            long startTime = System.currentTimeMillis();
            if ("POST".equals(request.method()) && request.body() != null) {
                if (request.body() instanceof FormBody) {
                    FormBody body = (FormBody) request.body();
                    JSONObject jsonObject = new JSONObject();
                    for (int i = 0; i < body.size(); i++) {
                        jsonObject.put(body.encodedName(i), body.encodedValue(i));
                    }
                    // TLog.e("URL: " + request.url() + "\t\t");
                    TLog.json(String.format("[%s] [%s]", "Params", request.url()), jsonObject.toString());
                }
                MediaType mediaType = request.body().contentType();
                if (mediaType != null && "json".equals(mediaType.subtype())) {
                    String postJson = bodyToString(request.body());
                    // TLog.e("URL: " + request.url() + "\t\t");
                    TLog.json(String.format("[%s] [%s]", "Params", request.url()), postJson);
                }
            } else {
                // TLog.e("URL: " + request.url() + "\t\t");
            }
            long endTime = System.currentTimeMillis();

            if (!TextUtils.isEmpty(urlInfo) && !isFileAddress(urlInfo)) {
                ResponseBody responseBody = response.peekBody(1024 * 1024);
                TLog.json(String.format("[%s] [%s]", request.method(), request.url()), responseBody.string());
            }
            TLog.e("Request Time: " + (endTime - startTime) * 1.0 / 1000 + "s" + "\t\t");
            TLog.l(urlInfo, false);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    private String bodyToString(final RequestBody request) {
        try {
            final RequestBody copy = request;
            final Buffer buffer = new Buffer();
            if (copy != null)
                copy.writeTo(buffer);
            else
                return "";
            return buffer.readUtf8();
        } catch (final IOException e) {
            return "";
        }
    }

    private String getLineTag(HttpUrl url) {
        String host = url.scheme() + "://" + url.host();
        String tag = url.toString().replace(host, "");
        if (tag.contains("?")) {
            tag = " " + tag.substring(0, tag.indexOf("?"));
        } else if (isFileAddress(tag)) {
            tag = "";
        }
        return tag;
    }

    private boolean isFileAddress(String url) {
        return API.FAQ_URL.contains(url.trim()) || API.OP_URL.contains(url.trim()) || url.endsWith(".json") || url.endsWith(".aiml") || url.endsWith(".ini")
                || url.endsWith(".jpg") || url.endsWith(".jpeg") || url.endsWith(".png") || url.endsWith(".mp4");
    }

}


