package net.aihelp.utils;

import android.content.Context;
import android.content.SharedPreferences;

import net.aihelp.BuildConfig;
import net.aihelp.config.AIHelpContext;

import java.util.HashMap;
import java.util.Map;

import androidx.annotation.RestrictTo;

@RestrictTo(RestrictTo.Scope.LIBRARY)
public class SpUtil {

    private Context context;

    public void init(Context context) {
        this.context = context;
    }

    private SpUtil() {
        if (BuildConfig.DEBUG && AIHelpContext.getInstance().getContext() == null) {
//            throw new IllegalArgumentException("AIHelp SDK not initialized.");
        }
        context = AIHelpContext.getInstance().getContext();
    }

    private volatile static SpUtil INSTANCE;

    public static SpUtil getInstance() {
        if (INSTANCE == null) {
            synchronized (SpUtil.class) {
                if (INSTANCE == null) {
                    INSTANCE = new SpUtil();
                }
            }
        }
        return INSTANCE;
    }

    /**
     * 保存在手机里面的文件名
     */
    private static final String FILE_NAME = "aihelp_share_data";

    private static final String FILE_NAME_OF_SDK_VERSION_1 = "com_ab_shared_preferences";

    public static final String KEY_DEVICE_ID_OF_SDK_VERSION_1_x = "suuid";
    public static final String KEY_DEVICE_ID_OF_SDK_VERSION_2_x = "key_device_id";

    /**
     * 保存数据的方法，我们需要拿到保存数据的具体类型，然后根据类型调用不同的保存方法
     *
     * @param key
     * @param object
     */
    public void put(String key, Object object) {
        if (isBadContext()) return;
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sp.edit();

        if (object instanceof String) {
            editor.putString(key, (String) object);
        } else if (object instanceof Integer) {
            editor.putInt(key, (Integer) object);
        } else if (object instanceof Boolean) {
            editor.putBoolean(key, (Boolean) object);
        } else if (object instanceof Float) {
            editor.putFloat(key, (Float) object);
        } else if (object instanceof Long) {
            editor.putLong(key, (Long) object);
        } else {
            editor.putString(key, object.toString());
        }

        editor.apply();
    }


    public long getLong(String key) {
        if (isBadContext()) return 0;
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        return sp.getLong(key, 0);
    }

    public long getLong(String key, long defaultObject) {
        if (isBadContext()) return 0;
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        return sp.getLong(key, defaultObject);
    }

    public float getFloat(String key) {
        if (isBadContext()) return 0f;
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        return sp.getFloat(key, 0f);
    }

    public float getFloat(String key, float defaultObject) {
        if (isBadContext()) return 0f;
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        return sp.getFloat(key, defaultObject);
    }

    public int getInt(String key) {
        if (isBadContext()) return 0;
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        return sp.getInt(key, 0);
    }

    public int getInt(String key, int defaultObject) {
        if (isBadContext()) return 0;
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        return sp.getInt(key, defaultObject);
    }

    public boolean getBoolean(String key) {
        if (isBadContext()) return false;
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        return sp.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultObject) {
        if (isBadContext()) return false;
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        return sp.getBoolean(key, defaultObject);
    }

    public String getString(String key, String defaultObject) {
        if (isBadContext()) return "";
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        return sp.getString(key, defaultObject);
    }

    public String getString(String key) {
        if (isBadContext()) return "";
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        return sp.getString(key, "");
    }


    /**
     * 移除某个key值已经对应的值
     *
     * @param key
     */
    public void remove(String key) {
        if (isBadContext()) return;
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sp.edit();
        editor.remove(key).apply();
    }

    /**
     * 清除所有数据
     */
    public void clear() {
        if (isBadContext()) return;
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sp.edit();
        editor.clear().apply();
    }

    /**
     * 查询某个key是否已经存在
     *
     * @param key
     * @return
     */
    public boolean contains(String key) {
        if (isBadContext()) return false;
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        return sp.contains(key);
    }

    public Map<String, ?> getAll() {
        if (isBadContext()) return new HashMap<>();
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, Context.MODE_PRIVATE);
        return sp.getAll();
    }

    public String get1_xDeviceId() {
        if (isBadContext()) return "";
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME_OF_SDK_VERSION_1, Context.MODE_PRIVATE);
        return sp.getString(KEY_DEVICE_ID_OF_SDK_VERSION_1_x, "");
    }

    public String get2_xDeviceId() {
        return getString(KEY_DEVICE_ID_OF_SDK_VERSION_2_x);
    }

    private boolean isBadContext() {
        if (context == null && AIHelpContext.getInstance().getContext() != null) {
            INSTANCE = new SpUtil();
            return true;
        }
        return false;
    }
}
