package net.aihelp.utils;

import android.content.Context;
import android.text.TextUtils;

import net.aihelp.exception.AIHelpInitException;

import java.util.regex.Pattern;

public class SchemaUtil {

    private static boolean validatePlatformId(String platformId) {
        return !TextUtils.isEmpty(platformId);
    }

    private static boolean validateDomainName(String domainName) {
        if (TextUtils.isEmpty(domainName)) {
            return false;
        } else {
            return Pattern.matches("^.+\\.(aihelp|aihelpcn).(net|online)$", domainName);
        }
    }

    private static boolean validateApiKey(String apiKey) {
        return !TextUtils.isEmpty(apiKey);
    }

    public static void validateInitializeCredentials(Context context, String apiKey, String domainName, String platformId) throws IllegalArgumentException {
        if (context == null) {
            throw new AIHelpInitException("The application used in AIHelpSupport#init can't be null!");
        } else if (!validateApiKey(apiKey)) {
            throw new AIHelpInitException("The appKey used in AIHelpSupport#init should not be empty!");
        } else if (!validateDomainName(domainName)) {
            throw new AIHelpInitException("The domain used in AIHelpSupport#init should be exactly same as AIHelp Dashboard configuration.");
        } else if (!validatePlatformId(platformId)) {
            throw new AIHelpInitException("The appId used in AIHelpSupport#init should not be empty!");
        }
    }

}
