package net.aihelp.ui.widget;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import net.aihelp.common.ConfigValues;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.IntentValues;
import net.aihelp.ui.faq.FaqContentFragment;
import net.aihelp.ui.faq.IFaqEventListener;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.ToastUtil;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatButton;

public class AIHelpServiceEntrance extends RelativeLayout {

    View vNotification;

    public AIHelpServiceEntrance(@NonNull Context context) {
        this(context, null);
    }

    public AIHelpServiceEntrance(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpServiceEntrance(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        View.inflate(context, ResResolver.getLayoutId("aihelp_layout_service_entrance"), this);

        TextView tvEntrance = findViewById(ResResolver.getViewId("aihelp_tv_entrance"));
        tvEntrance.setText(CustomConfig.HelpCenter.faqCSEntranceText);
        tvEntrance.setBackground(Styles.getDrawable(Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor), 8));

        vNotification = findViewById(ResResolver.getViewId("aihelp_v_unread_status"));
        vNotification.setBackground(Styles.getDrawable(Color.parseColor("#FF4747"), 999));
        vNotification.setVisibility(GONE);

        updateEntranceStatus(false, false);

    }

    public void setup(Bundle bundle, IFaqEventListener faqEventListener) {
        if (bundle != null && faqEventListener != null) {
            updateViewVisibility(bundle);
            updateViewClickEvent(bundle, faqEventListener);
        }
    }

    public void updateViewVisibility(Bundle bundle) {

        int supportMoment = bundle.getInt(IntentValues.FAQ_SUPPORT_MOMENT, ConfigValues.MOMENT_NEVER);

        // NEVER has highest priority, even there are unread messages
        if (supportMoment == ConfigValues.MOMENT_NEVER) {
            updateEntranceStatus(false, false);
            return;
        }

        if (ResponseMqttHelper.isHasUnreadMsg()) {
            updateEntranceStatus(true, true);
        } else if (supportMoment == ConfigValues.MOMENT_ALWAYS || ResponseMqttHelper.isTicketActive()) {
            updateEntranceStatus(true, false);
        } else {
            switch (supportMoment) {
                case ConfigValues.MOMENT_ONLY_IN_ANSWER_PAGE:
                case ConfigValues.MOMENT_AFTER_MARKING_UNHELPFUL:
                    if (!FaqContentFragment.class.getSimpleName().equals(getClass().getSimpleName())) {
                        updateEntranceStatus(false, false);
                    }
                    break;
                default:
                    updateEntranceStatus(false, false);
                    break;
            }
        }
    }

    private void updateEntranceStatus(boolean entranceVisible, boolean notificationVisible) {
        if (entranceVisible) {
            setVisibility(View.VISIBLE);
            vNotification.setVisibility(notificationVisible ? VISIBLE : GONE);
        } else {
            setVisibility(View.GONE);
        }
    }

    private void updateViewClickEvent(Bundle bundle, IFaqEventListener faqEventListener) {
        setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                boolean skipElva = bundle.getBoolean(IntentValues.SKIP_ELVA_IN_FAQ);
                if (skipElva) {
                    // 标识 Conversation，从而保证 mqtt 可以正常断开
                    bundle.putInt(IntentValues.SUPPORT_MODE, IntentValues.MODE_CONVERSATION);
                    faqEventListener.onIntentToConversation(bundle);
                } else {
                    faqEventListener.onIntentToElvaBot(bundle);
                }
                vNotification.setVisibility(View.GONE);
            }
        });
    }

}
