package net.aihelp.ui.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;

import net.aihelp.common.IntentValues;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import androidx.appcompat.widget.AppCompatImageView;

public class AIHelpMsgView extends RelativeLayout {

    private AppCompatImageView ivRight;
    private View unreadDot;

    public AIHelpMsgView(Context context) {
        this(context, null);
    }

    public AIHelpMsgView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpMsgView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        View rootView = View.inflate(context, ResResolver.getLayoutId("aihelp_layout_msg_view"), this);
        ivRight = rootView.findViewById(ResResolver.getViewId("aihelp_iv_right"));
        unreadDot = rootView.findViewById(ResResolver.getViewId("aihelp_v_unread_status"));
    }

    protected int dip2px(Context context, double dpValue) {
        float density = context.getResources().getDisplayMetrics().density;
        return (int) (dpValue * density + 0.5);
    }

    public void updateImageResource(int supportAction, String svgResource) {
        unreadDot.setVisibility(supportAction == IntentValues.SUPPORT_ACTION_MSG_UNREAD ? VISIBLE : GONE);
        if (supportAction == IntentValues.SUPPORT_ACTION_FAQ) {
            Styles.reRenderImageView(ivRight, svgResource);
        } else {
            Styles.reRenderImageView(ivRight, svgResource);
        }
    }


}
