package net.aihelp.ui.widget;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;

import net.aihelp.common.CustomConfig;
import net.aihelp.utils.Styles;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatButton;

public class AIHelpButton extends AppCompatButton {

    public AIHelpButton(@NonNull Context context) {
        this(context, null);
    }

    public AIHelpButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        setMinWidth((int) Styles.dpToPx(context, 84));
        setMinHeight((int) Styles.dpToPx(context, 28));

        setBackground(Styles.getDrawable(Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor), 8));

        setTextColor(Color.WHITE);
        setGravity(Gravity.CENTER);

        setPadding(
                (int) Styles.dpToPx(context, 12),
                (int) Styles.dpToPx(context, 7),
                (int) Styles.dpToPx(context, 12),
                (int) Styles.dpToPx(context, 7)
        );

    }
}
